/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.util.StringTokenizer;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class DoubleArrayParser
implements DataParser {
    public Class getType() {
        return double[].class;
    }

    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof double[])) {
            throw new IllegalArgumentException("This class can only format Objects of type double[].");
        }
        double[] dArray = (double[])object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(dArray[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public boolean canParse(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"[](){}, ");
            while (stringTokenizer.hasMoreTokens()) {
                Double.parseDouble(stringTokenizer.nextToken());
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public Object parse(String string) throws DataParseException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"[](){}, ");
            double[] dArray = new double[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                dArray[n] = Double.parseDouble(string2);
                ++n;
            }
            return dArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataParseException(numberFormatException);
        }
    }
}

