/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import prefuse.data.Table;
import prefuse.data.io.sql.SQLDataHandler;

public class DefaultSQLDataHandler
implements SQLDataHandler {
    private boolean m_ignoreUnknownTypes;

    public DefaultSQLDataHandler() {
        this(true);
    }

    public DefaultSQLDataHandler(boolean bl) {
        this.m_ignoreUnknownTypes = bl;
    }

    public void setIgnoreUnknownTypes(boolean bl) {
        this.m_ignoreUnknownTypes = bl;
    }

    public boolean isIgnoreUnknownTypes() {
        return this.m_ignoreUnknownTypes;
    }

    public void process(Table table, int n, ResultSet resultSet, int n2) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        String string = resultSetMetaData.getColumnName(n2);
        int n3 = resultSetMetaData.getColumnType(n2);
        switch (n3) {
            case 2003: {
                table.set(n, string, (Object)resultSet.getArray(n2));
                break;
            }
            case -5: {
                table.setLong(n, string, resultSet.getLong(n2));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                table.set(n, string, (Object)resultSet.getBytes(n2));
                break;
            }
            case -7: 
            case 16: {
                table.setBoolean(n, string, resultSet.getBoolean(n2));
                break;
            }
            case 2004: {
                table.set(n, string, (Object)resultSet.getBlob(n2));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                table.setString(n, string, resultSet.getString(n2));
                break;
            }
            case 2005: {
                table.set(n, string, (Object)resultSet.getClob(n2));
                break;
            }
            case 91: {
                table.setDate(n, string, (Date)resultSet.getDate(n2));
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                table.setDouble(n, string, resultSet.getDouble(n2));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                table.setInt(n, string, resultSet.getInt(n2));
                break;
            }
            case 2000: {
                table.set(n, string, resultSet.getObject(n2));
                break;
            }
            case 7: {
                table.setFloat(n, string, resultSet.getFloat(n2));
                break;
            }
            case 2006: {
                table.set(n, string, (Object)resultSet.getRef(n2));
                break;
            }
            case 92: {
                table.setDate(n, string, (Date)resultSet.getTime(n2));
                break;
            }
            case 93: {
                table.setDate(n, string, (Date)resultSet.getTimestamp(n2));
                break;
            }
            default: {
                if (this.m_ignoreUnknownTypes) break;
                table.set(n, string, resultSet.getObject(n2));
            }
        }
    }

    public Class getDataType(String string, int n) {
        switch (n) {
            case 2003: {
                return Array.class;
            }
            case -5: {
                return Long.TYPE;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case -7: 
            case 16: {
                return Boolean.TYPE;
            }
            case 2004: {
                return Blob.class;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 91: {
                return java.sql.Date.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 6: 
            case 8: {
                return Double.TYPE;
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.TYPE;
            }
            case 2000: {
                return Object.class;
            }
            case 7: {
                return Float.TYPE;
            }
            case 2006: {
                return Ref.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
        }
        if (!this.m_ignoreUnknownTypes) {
            return Object.class;
        }
        return null;
    }
}

