/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class ByteColumn
extends AbstractColumn {
    private byte[] m_values;
    private int m_size;

    public ByteColumn() {
        this(0, 10, 0);
    }

    public ByteColumn(int n) {
        this(n, n, 0);
    }

    public ByteColumn(int n, int n2, byte by) {
        super(Byte.TYPE, new Byte(by));
        if (n2 < n) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new byte[n2];
        Arrays.fill(this.m_values, by);
        this.m_size = n;
    }

    public int getRowCount() {
        return this.m_size;
    }

    public void setMaximumRow(int n) {
        if (n > this.m_values.length) {
            int n2 = Math.max(3 * this.m_values.length / 2 + 1, n);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.m_values, 0, byArray, 0, this.m_size);
            Arrays.fill(byArray, this.m_size, n2, (Byte)this.m_defaultValue);
            this.m_values = byArray;
        }
        this.m_size = n;
    }

    public Object get(int n) {
        return new Byte(this.getByte(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object object, int n) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Number) {
            this.setInt(((Number)object).byteValue(), n);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n);
        }
    }

    public byte getByte(int n) throws DataTypeException {
        if (n < 0 || n > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        return this.m_values[n];
    }

    public int getInt(int n) throws DataTypeException {
        if (n < 0 || n > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        return this.m_values[n];
    }

    public void setInt(int n, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n2 < 0 || n2 >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        byte by = this.m_values[n2];
        if (by == n) {
            return;
        }
        this.m_values[n2] = (byte)n;
        this.fireColumnEvent(n2, by);
    }

    public long getLong(int n) throws DataTypeException {
        return this.getInt(n);
    }

    public float getFloat(int n) throws DataTypeException {
        return this.getInt(n);
    }

    public double getDouble(int n) throws DataTypeException {
        return this.getInt(n);
    }
}

