/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Date;
import prefuse.data.DataTypeException;
import prefuse.data.Table;
import prefuse.data.column.BooleanColumn;
import prefuse.data.column.ByteColumn;
import prefuse.data.column.Column;
import prefuse.data.column.ConstantColumn;
import prefuse.data.column.DateColumn;
import prefuse.data.column.DoubleColumn;
import prefuse.data.column.ExpressionColumn;
import prefuse.data.column.FloatColumn;
import prefuse.data.column.IntColumn;
import prefuse.data.column.LongColumn;
import prefuse.data.column.ObjectColumn;
import prefuse.data.expression.Expression;

public class ColumnFactory {
    public static final Column getColumn(Class clazz) {
        return ColumnFactory.getColumn(clazz, 0, 0, null);
    }

    public static final Column getColumn(Class clazz, int n) {
        return ColumnFactory.getColumn(clazz, n, n, null);
    }

    public static final Column getColumn(Class clazz, int n, Object object) {
        return ColumnFactory.getColumn(clazz, n, n, object);
    }

    public static final Column getColumn(Class clazz, int n, int n2, Object object) {
        if (clazz == Byte.TYPE) {
            if (object == null) {
                return new ByteColumn(n);
            }
            byte by = ((Number)object).byteValue();
            return new ByteColumn(n, n, by);
        }
        if (clazz == Integer.TYPE) {
            if (object == null) {
                return new IntColumn(n);
            }
            int n3 = ((Number)object).intValue();
            return new IntColumn(n, n, n3);
        }
        if (clazz == Long.TYPE) {
            if (object == null) {
                return new LongColumn(n);
            }
            long l = ((Number)object).longValue();
            return new LongColumn(n, n, l);
        }
        if (clazz == Float.TYPE) {
            if (object == null) {
                return new FloatColumn(n);
            }
            float f = ((Number)object).floatValue();
            return new FloatColumn(n, n, f);
        }
        if (clazz == Double.TYPE) {
            if (object == null) {
                return new DoubleColumn(n);
            }
            double d = ((Number)object).doubleValue();
            return new DoubleColumn(n, n, d);
        }
        if (clazz == Boolean.TYPE) {
            if (object == null) {
                return new BooleanColumn(n);
            }
            boolean bl = (Boolean)object;
            return new BooleanColumn(n, n, bl);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            if (object == null) {
                return new DateColumn(clazz, n);
            }
            Date date = (Date)object;
            return new DateColumn(clazz, n, n, date.getTime());
        }
        if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE || clazz == Void.TYPE) {
            throw new DataTypeException(clazz);
        }
        return new ObjectColumn(clazz, n, n, object);
    }

    public static final Column getColumn(Table table, Expression expression) {
        return new ExpressionColumn(table, expression);
    }

    public static final Column getConstantColumn(Class clazz, Object object) {
        return new ConstantColumn(clazz, object);
    }
}

