/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Tree;
import prefuse.data.event.GraphListener;
import prefuse.util.StringLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.visual.VisualTree;

public class JPrefuseTree
extends JTree {
    private Tree m_tree;
    private String m_field;

    public JPrefuseTree(Tree tree, String string) {
        this.m_tree = tree;
        this.m_field = string;
        PrefuseTreeModel prefuseTreeModel = new PrefuseTreeModel();
        super.setModel(prefuseTreeModel);
        this.m_tree.addGraphModelListener(prefuseTreeModel);
    }

    public Tree getTree() {
        return this.m_tree;
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object == null) {
            return "";
        }
        if (object instanceof Node) {
            Object object2 = ((Node)object).get(this.m_field);
            if (object2.getClass().isArray()) {
                return StringLib.getArrayString(object2);
            }
            return object2.toString();
        }
        return object.toString();
    }

    public static JFrame showTreeWindow(Tree tree, String string) {
        JPrefuseTree jPrefuseTree = new JPrefuseTree(tree, string);
        String string2 = tree.toString();
        if (tree instanceof VisualTree) {
            string2 = ((VisualTree)tree).getGroup() + " " + string2;
        }
        JFrame jFrame = new JFrame(string2);
        jFrame.getContentPane().add(new JScrollPane(jPrefuseTree));
        jFrame.pack();
        jFrame.setVisible(true);
        return jFrame;
    }

    public class PrefuseTreeModel
    implements TreeModel,
    GraphListener {
        private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();

        public Object getRoot() {
            return JPrefuseTree.this.m_tree.getRoot();
        }

        public Object getChild(Object object, int n) {
            Node node = ((Node)object).getChild(n);
            if (node == null) {
                throw new IllegalArgumentException("Index out of range: " + n);
            }
            return node;
        }

        public int getChildCount(Object object) {
            return ((Node)object).getChildCount();
        }

        public boolean isLeaf(Object object) {
            return ((Node)object).getChildCount() == 0;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public int getIndexOfChild(Object object, Object object2) {
            return ((Node)object).getChildIndex((Node)object2);
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            if (!this.m_listeners.contains(treeModelListener)) {
                this.m_listeners.add(treeModelListener);
            }
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.m_listeners.remove(treeModelListener);
        }

        public void graphChanged(Graph graph, String string, int n, int n2, int n3, int n4) {
            if (this.m_listeners == null || this.m_listeners.size() == 0) {
                return;
            }
            boolean bl = string.equals(Graph.NODES);
            if (n4 != 0 && bl) {
                return;
            }
            if (n4 == 0 && !bl) {
                return;
            }
            for (int i = n; i <= n2; ++i) {
                Node node = null;
                node = bl ? graph.getNode(i) : graph.getEdge(i).getTargetNode();
                Object[] objectArray = new Object[node.getDepth() + 1];
                int n5 = objectArray.length;
                while (--n5 >= 0) {
                    objectArray[n5] = node;
                    node = node.getParent();
                }
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray);
                Object[] objectArray2 = this.m_listeners.getArray();
                block7: for (int j = 0; j < objectArray2.length; ++j) {
                    TreeModelListener treeModelListener = (TreeModelListener)objectArray2[j];
                    switch (n4) {
                        case 1: {
                            treeModelListener.treeNodesInserted(treeModelEvent);
                            continue block7;
                        }
                        case -1: {
                            treeModelListener.treeNodesRemoved(treeModelEvent);
                            continue block7;
                        }
                        case 0: {
                            treeModelListener.treeNodesChanged(treeModelEvent);
                        }
                    }
                }
            }
        }
    }
}

