/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimeLib {
    public static final int MILLENIUM = -1000;
    public static final int CENTURY = -100;
    public static final int DECADE = -10;
    private static final double SECOND_MILLIS = 1000.0;
    private static final double MINUTE_MILLIS = 60000.0;
    private static final double HOUR_MILLIS = 3600000.0;
    private static final double DAY_MILLIS = 8.64054E7;
    private static final double WEEK_MILLIS = 6.048378E8;
    private static final double MONTH_MILLIS = 2.62989955845E9;
    private static final double YEAR_MILLIS = 3.157253316E10;
    private static final double DECADE_MILLIS = 3.157253316E11;
    private static final double CENTURY_MILLIS = 3.157253316E12;
    private static final double MILLENIUM_MILLIS = 3.157253316E13;
    private static final int[] CALENDAR_FIELDS = new int[]{1, 2, 5, 11, 12, 13, 14};

    private TimeLib() {
    }

    public static int getUnitsBetween(long l, long l2, int n) {
        boolean bl = false;
        if (l2 < l) {
            long l3 = l2;
            l2 = l;
            l = l3;
            bl = true;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        gregorianCalendar2.setTimeInMillis(l2);
        int n2 = TimeLib.estimateUnitsBetween(l, l2, n);
        boolean bl2 = TimeLib.isMultiYear(n);
        if (bl2) {
            gregorianCalendar.add(1, -n * (n2 - 2));
            n2 = -n * n2;
        } else {
            gregorianCalendar.add(n, n2 - 2);
        }
        int n3 = bl2 ? 1 : n;
        int n4 = bl2 ? -n : 1;
        int n5 = n2 - n4;
        while (true) {
            gregorianCalendar.add(n3, n4);
            if (gregorianCalendar.after(gregorianCalendar2)) {
                return bl ? n4 - n5 : n5 - n4;
            }
            n5 += n4;
        }
    }

    private static int estimateUnitsBetween(long l, long l2, int n) {
        long l3 = l2 - l;
        switch (n) {
            case 14: {
                return (int)l3;
            }
            case 13: {
                return (int)((double)l3 / 1000.0 + 0.5);
            }
            case 12: {
                return (int)((double)l3 / 60000.0 + 0.5);
            }
            case 10: 
            case 11: {
                return (int)((double)l3 / 3600000.0 + 0.5);
            }
            case 5: 
            case 8: {
                return (int)((double)l3 / 8.64054E7 + 0.5);
            }
            case 3: {
                return (int)((double)l3 / 6.048378E8 + 0.5);
            }
            case 2: {
                return (int)((double)l3 / 2.62989955845E9 + 0.5);
            }
            case 1: {
                return (int)((double)l3 / 3.157253316E10 + 0.5);
            }
            case -10: {
                return (int)((double)l3 / 3.157253316E11 + 0.5);
            }
            case -100: {
                return (int)((double)l3 / 3.157253316E12 + 0.5);
            }
            case -1000: {
                return (int)((double)l3 / 3.157253316E13 + 0.5);
            }
        }
        return 0;
    }

    public static void increment(Calendar calendar, int n, int n2) {
        if (TimeLib.isMultiYear(n)) {
            calendar.add(1, -n * n2);
        } else {
            calendar.add(n, n2);
        }
    }

    public static int get(Calendar calendar, int n) {
        if (TimeLib.isMultiYear(n)) {
            int n2 = calendar.get(1);
            return -n * (n2 / -n);
        }
        return calendar.get(n);
    }

    public static long getDate(Calendar calendar, int n, int n2, int n3) {
        calendar.clear(14);
        calendar.set(n, n2, n3, 0, 0, 0);
        return calendar.getTimeInMillis();
    }

    public static long getTime(Calendar calendar, int n, int n2, int n3) {
        calendar.clear(14);
        calendar.set(1970, 0, 1, n, n2, n3);
        return calendar.getTimeInMillis();
    }

    public static Date getDate(Class clazz, long l) {
        try {
            Constructor constructor = clazz.getConstructor(Long.TYPE);
            return (Date)constructor.newInstance(new Long(l));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static long getClearedTime(long l, Calendar calendar, int n) {
        calendar.setTimeInMillis(l);
        TimeLib.clearTo(calendar, n);
        return calendar.getTimeInMillis();
    }

    public static Calendar clearTo(Calendar calendar, int n) {
        int n2;
        for (int i = CALENDAR_FIELDS.length - 1; i >= 1 && n != CALENDAR_FIELDS[i]; --i) {
            n2 = CALENDAR_FIELDS[i] == 5 ? 1 : 0;
            calendar.set(CALENDAR_FIELDS[i], n2);
        }
        if (TimeLib.isMultiYear(n)) {
            n2 = calendar.get(1);
            n2 = -n * (n2 / -n);
            calendar.set(1, n2);
        }
        return calendar;
    }

    public static boolean isMultiYear(int n) {
        return n == -10 || n == -100 || n == -1000;
    }
}

