/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class DateParser
implements DataParser {
    protected DateFormat m_dfmt;
    protected ParsePosition m_pos;

    public DateParser() {
        this(DateFormat.getDateInstance(3));
    }

    public DateParser(DateFormat dateFormat) {
        this.m_dfmt = dateFormat;
        this.m_pos = new ParsePosition(0);
    }

    public Class getType() {
        return java.sql.Date.class;
    }

    public String format(Object object) {
        return object == null ? null : this.m_dfmt.format(object);
    }

    public boolean canParse(String string) {
        try {
            this.parseDate(string);
            return true;
        }
        catch (DataParseException dataParseException) {
            return false;
        }
    }

    public Object parse(String string) throws DataParseException {
        return this.parseDate(string);
    }

    public java.sql.Date parseDate(String string) throws DataParseException {
        Date date;
        this.m_pos.setErrorIndex(0);
        this.m_pos.setIndex(0);
        java.sql.Date date2 = null;
        try {
            date2 = java.sql.Date.valueOf(string);
            this.m_pos.setIndex(string.length());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            date2 = null;
        }
        if (date2 == null && (date = this.m_dfmt.parse(string, this.m_pos)) != null) {
            date2 = new java.sql.Date(date.getTime());
        }
        if (date2 == null || this.m_pos.getIndex() < string.length()) {
            throw new DataParseException("Could not parse Date: " + string);
        }
        return date2;
    }
}

