/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.InputStream;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.io.AbstractGraphReader;
import prefuse.data.io.DataIOException;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ParserFactory;

public class TreeMLReader
extends AbstractGraphReader {
    private ParserFactory m_pf = ParserFactory.getDefaultFactory();

    public Graph readGraph(InputStream inputStream) throws DataIOException {
        try {
            TreeMLHandler treeMLHandler = new TreeMLHandler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)treeMLHandler);
            return treeMLHandler.getTree();
        }
        catch (Exception exception) {
            throw new DataIOException(exception);
        }
    }

    public class TreeMLHandler
    extends DefaultHandler
    implements Tokens {
        private Table m_nodes = null;
        private Tree m_tree = null;
        private Node m_activeNode = null;
        private boolean m_inSchema = true;

        public void startDocument() {
            this.m_tree = new Tree();
            this.m_nodes = this.m_tree.getNodeTable();
        }

        private void schemaCheck() {
            if (this.m_inSchema) {
                this.m_inSchema = false;
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals("branch") || string3.equals("leaf")) {
                this.m_activeNode = this.m_activeNode.getParent();
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string3.equals("attributeDecl")) {
                if (!this.m_inSchema) {
                    throw new RuntimeException("All declarations must be done before nodes begin");
                }
                String string4 = attributes.getValue("name");
                String string5 = attributes.getValue("type");
                Class clazz = this.parseType(string5);
                this.m_nodes.addColumn(string4, clazz);
            } else if (string3.equals("branch") || string3.equals("leaf")) {
                this.schemaCheck();
                Node node = this.m_activeNode == null ? this.m_tree.addRoot() : this.m_tree.addChild(this.m_activeNode);
                this.m_activeNode = node;
            } else if (string3.equals("attribute")) {
                this.parseAttribute(attributes);
            }
        }

        protected void parseAttribute(Attributes attributes) {
            String string = null;
            String string2 = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string3 = attributes.getQName(i);
                if (string3.equals("name")) {
                    string = attributes.getValue(i);
                    continue;
                }
                if (!string3.equals("value")) continue;
                string2 = attributes.getValue(i);
            }
            if (string == null || string2 == null) {
                System.err.println("Attribute under-specified");
                return;
            }
            try {
                Object object = this.parse(string2, this.m_nodes.getColumnType(string));
                this.m_activeNode.set(string, object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        protected Object parse(String string, Class clazz) throws DataParseException {
            DataParser dataParser = TreeMLReader.this.m_pf.getParser(clazz);
            return dataParser.parse(string);
        }

        protected Class parseType(String string) {
            if ((string = Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase()).equals("Int") || string.equals("Integer")) {
                return Integer.TYPE;
            }
            if (string.equals("Long")) {
                return Long.TYPE;
            }
            if (string.equals("Float")) {
                return Float.TYPE;
            }
            if (string.equals("Double") || string.equals("Real")) {
                return Double.TYPE;
            }
            if (string.equals("Boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("String")) {
                return String.class;
            }
            if (string.equals("Date")) {
                return Date.class;
            }
            throw new RuntimeException("Unrecognized data type: " + string);
        }

        public Tree getTree() {
            return this.m_tree;
        }
    }

    public static interface Tokens {
        public static final String TREE = "tree";
        public static final String BRANCH = "branch";
        public static final String LEAF = "leaf";
        public static final String ATTR = "attribute";
        public static final String NAME = "name";
        public static final String VALUE = "value";
        public static final String TYPE = "type";
        public static final String DECLS = "declarations";
        public static final String DECL = "attributeDecl";
        public static final String INT = "Int";
        public static final String INTEGER = "Integer";
        public static final String LONG = "Long";
        public static final String FLOAT = "Float";
        public static final String REAL = "Real";
        public static final String STRING = "String";
        public static final String DATE = "Date";
        public static final String CATEGORY = "Category";
        public static final String BOOLEAN = "Boolean";
        public static final String DOUBLE = "Double";
    }
}

