/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class FloatColumn
extends AbstractColumn {
    private float[] m_values;
    private int m_size;

    public FloatColumn() {
        this(0, 10, 0.0f);
    }

    public FloatColumn(int n) {
        this(n, n, 0.0f);
    }

    public FloatColumn(int n, int n2, float f) {
        super(Float.TYPE, new Float(f));
        if (n2 < n) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new float[n2];
        Arrays.fill(this.m_values, f);
        this.m_size = n;
    }

    public int getRowCount() {
        return this.m_size;
    }

    public void setMaximumRow(int n) {
        if (n > this.m_values.length) {
            int n2 = Math.max(3 * this.m_values.length / 2 + 1, n);
            float[] fArray = new float[n2];
            System.arraycopy(this.m_values, 0, fArray, 0, this.m_size);
            Arrays.fill(fArray, this.m_size, n2, ((Float)this.m_defaultValue).floatValue());
            this.m_values = fArray;
        }
        this.m_size = n;
    }

    public Object get(int n) {
        return new Float(this.getFloat(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object object, int n) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Number) {
            this.setFloat(((Number)object).floatValue(), n);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n);
        }
    }

    public float getFloat(int n) throws DataTypeException {
        if (n < 0 || n > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        return this.m_values[n];
    }

    public void setFloat(float f, int n) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n < 0 || n >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        float f2 = this.m_values[n];
        if (f2 == f) {
            return;
        }
        this.m_values[n] = f;
        this.fireColumnEvent(n, f2);
    }

    public int getInt(int n) throws DataTypeException {
        return (int)this.getFloat(n);
    }

    public long getLong(int n) throws DataTypeException {
        return (long)this.getFloat(n);
    }

    public double getDouble(int n) throws DataTypeException {
        return this.getFloat(n);
    }
}

