/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.logging.Logger;
import prefuse.action.assignment.SizeAction;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.util.MathLib;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;

public class DataSizeAction
extends SizeAction {
    protected static final double NO_SIZE = Double.NaN;
    protected String m_dataField;
    protected double m_minSize = 1.0;
    protected double m_sizeRange;
    protected int m_scale = 0;
    protected int m_bins = -1;
    protected boolean m_inferBounds = true;
    protected boolean m_inferRange = true;
    protected boolean m_is2DArea = true;
    protected double[] m_dist;
    protected int m_tempScale;

    public DataSizeAction(String string, String string2) {
        super(string, Double.NaN);
        this.m_dataField = string2;
    }

    public DataSizeAction(String string, String string2, int n) {
        this(string, string2, n, 0);
    }

    public DataSizeAction(String string, String string2, int n, int n2) {
        super(string, Double.NaN);
        this.m_dataField = string2;
        this.setScale(n2);
        this.setBinCount(n);
    }

    public String getDataField() {
        return this.m_dataField;
    }

    public void setDataField(String string) {
        this.m_dataField = string;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Unrecognized scale value: " + n);
        }
        this.m_scale = n;
    }

    public int getBinCount() {
        return this.m_bins;
    }

    public void setBinCount(int n) {
        if (this.m_scale == 3 && n <= 0) {
            throw new IllegalArgumentException("The quantile scale can not be used without binning. Use a bin value greater than zero.");
        }
        this.m_bins = n;
    }

    public boolean is2DArea() {
        return this.m_is2DArea;
    }

    public void setIs2DArea(boolean bl) {
        this.m_is2DArea = bl;
    }

    public double getMinimumSize() {
        return this.m_minSize;
    }

    public void setMinimumSize(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d) || d <= 0.0) {
            throw new IllegalArgumentException("Minimum size value must be a finite number greater than zero.");
        }
        if (this.m_inferRange) {
            this.m_sizeRange += this.m_minSize - d;
        }
        this.m_minSize = d;
    }

    public double getMaximumSize() {
        return this.m_minSize + this.m_sizeRange;
    }

    public void setMaximumSize(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d) || d <= 0.0) {
            this.m_inferRange = true;
        } else {
            this.m_inferRange = false;
            this.m_sizeRange = d - this.m_minSize;
        }
    }

    public void setDefaultSize(double d) {
        throw new UnsupportedOperationException();
    }

    protected void setup() {
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        this.m_tempScale = this.m_scale;
        if (this.m_inferBounds) {
            if (this.m_scale == 3 && this.m_bins > 0) {
                double[] dArray = DataLib.toDoubleArray(tupleSet.tuples(), this.m_dataField);
                this.m_dist = MathLib.quantiles(this.m_bins, dArray);
            } else {
                if (this.m_scale == 3) {
                    Logger.getLogger(this.getClass().getName()).warning("Can't use quantile scale with no binning. Defaulting to linear scale. Set the bin value greater than zero to use a quantile scale.");
                    this.m_scale = 0;
                }
                this.m_dist = new double[2];
                this.m_dist[0] = DataLib.min(tupleSet, this.m_dataField).getDouble(this.m_dataField);
                this.m_dist[1] = DataLib.max(tupleSet, this.m_dataField).getDouble(this.m_dataField);
            }
            if (this.m_inferRange) {
                this.m_sizeRange = this.m_dist[this.m_dist.length - 1] / this.m_dist[0] - this.m_minSize;
            }
        }
    }

    protected void finish() {
        this.m_scale = this.m_tempScale;
    }

    public double getSize(VisualItem visualItem) {
        double d = super.getSize(visualItem);
        if (!Double.isNaN(d)) {
            return d;
        }
        double d2 = visualItem.getDouble(this.m_dataField);
        double d3 = MathLib.interp(this.m_scale, d2, this.m_dist);
        if (this.m_bins < 1) {
            d2 = this.m_minSize + d3 * this.m_sizeRange;
        } else {
            int n = d3 < 1.0 ? (int)(d3 * (double)this.m_bins) : this.m_bins - 1;
            d2 = this.m_minSize + (double)n * (this.m_sizeRange / (double)(this.m_bins - 1));
        }
        return this.m_is2DArea ? PrefuseLib.getSize2D(d2) : d2;
    }
}

