/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Comparator;
import java.util.Date;
import prefuse.data.DataTypeException;
import prefuse.util.collections.BooleanIntBitSetMap;
import prefuse.util.collections.DoubleIntTreeMap;
import prefuse.util.collections.FloatIntTreeMap;
import prefuse.util.collections.IncompatibleComparatorException;
import prefuse.util.collections.IntIntTreeMap;
import prefuse.util.collections.IntSortedMap;
import prefuse.util.collections.LiteralComparator;
import prefuse.util.collections.LiteralIterator;
import prefuse.util.collections.LongIntTreeMap;
import prefuse.util.collections.ObjectIntTreeMap;

public class SortedMapFactory {
    public static IntSortedMap getMap(Class clazz, Comparator comparator, boolean bl) throws IncompatibleComparatorException {
        if (!SortedMapFactory.comparatorCheck(clazz, comparator)) {
            throw new IncompatibleComparatorException();
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Byte.TYPE)) {
            return new IntIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Long.TYPE) || clazz.isAssignableFrom(Date.class)) {
            return new LongIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Float.TYPE)) {
            return new FloatIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Double.TYPE)) {
            return new DoubleIntTreeMap((LiteralComparator)comparator, !bl);
        }
        if (clazz.equals(Boolean.TYPE)) {
            return new BooleanIntBitSetMap();
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return new ObjectIntTreeMap(comparator, !bl);
        }
        throw new DataTypeException("No map available for the provided type");
    }

    public static boolean comparatorCheck(Class clazz, Comparator comparator) {
        if (comparator == null) {
            return true;
        }
        if (clazz.equals(Integer.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0, 0);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Long.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0L, 0L);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Float.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0.0f, 0.0f);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Double.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(0.0, 0.0);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (clazz.equals(Boolean.TYPE)) {
            if (!(comparator instanceof LiteralIterator)) {
                return false;
            }
            try {
                ((LiteralComparator)comparator).compare(false, false);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return true;
        }
        throw new DataTypeException("No comparator available for the provided type");
    }
}

