/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import prefuse.data.Tuple;
import prefuse.data.expression.Expression;
import prefuse.data.expression.IfExpression;
import prefuse.data.expression.ObjectLiteral;
import prefuse.data.expression.Predicate;

public class PredicateChain {
    private Expression m_head = new ObjectLiteral(null);
    private IfExpression m_tail = null;

    public Expression getExpression() {
        return this.m_head;
    }

    public Object get(Tuple tuple) {
        return this.m_head.get(tuple);
    }

    public void add(Predicate predicate, Object object) {
        if (this.m_tail == null) {
            this.m_tail = new IfExpression(predicate, new ObjectLiteral(object), this.m_head);
            this.m_head = this.m_tail;
        } else {
            IfExpression ifExpression = new IfExpression(predicate, new ObjectLiteral(object), this.m_tail.getElseExpression());
            this.m_tail.setElseExpression(ifExpression);
            this.m_tail = ifExpression;
        }
    }

    public boolean remove(Predicate predicate) {
        if (predicate == null) {
            return false;
        }
        IfExpression ifExpression = null;
        Expression expression = this.m_head;
        while (expression instanceof IfExpression) {
            IfExpression ifExpression2 = (IfExpression)expression;
            Predicate predicate2 = ifExpression2.getTestPredicate();
            if (predicate.equals(predicate2)) {
                Expression expression2 = ifExpression2.getElseExpression();
                ifExpression2.setElseExpression(new ObjectLiteral(null));
                if (ifExpression != null) {
                    ifExpression.setElseExpression(expression2);
                    if (ifExpression2 == this.m_tail) {
                        this.m_tail = ifExpression;
                    }
                } else {
                    this.m_head = expression2;
                    if (ifExpression2 == this.m_tail) {
                        this.m_tail = null;
                    }
                }
                return true;
            }
            ifExpression = ifExpression2;
            expression = ifExpression2.getElseExpression();
        }
        return false;
    }

    public void clear() {
        this.m_head = new ObjectLiteral(null);
        this.m_tail = null;
    }
}

