/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.util.StringTokenizer;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.LongParser;

public class LongArrayParser
implements DataParser {
    public Class getType() {
        return long[].class;
    }

    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof long[])) {
            throw new IllegalArgumentException("This class can only format Objects of type long[].");
        }
        long[] lArray = (long[])object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(lArray[i]).append('L');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public boolean canParse(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"[](){}, ");
            while (stringTokenizer.hasMoreTokens()) {
                LongParser.parseLong(stringTokenizer.nextToken());
            }
            return true;
        }
        catch (DataParseException dataParseException) {
            return false;
        }
    }

    public Object parse(String string) throws DataParseException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"[](){}, ");
            long[] lArray = new long[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                lArray[n] = LongParser.parseLong(string2);
                ++n;
            }
            return lArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataParseException(numberFormatException);
        }
    }
}

