/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.logging.Logger;
import prefuse.action.EncoderAction;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.util.ColorLib;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;

public class ColorAction
extends EncoderAction {
    protected String m_colorField;
    protected String m_startField;
    protected String m_endField;
    protected int m_cidx;
    protected int m_sidx;
    protected int m_eidx;
    protected int m_defaultColor = ColorLib.gray(0);

    public ColorAction(String string, String string2) {
        super(string);
        this.setField(string2);
    }

    public ColorAction(String string, String string2, int n) {
        this(string, string2);
        this.m_defaultColor = n;
    }

    public ColorAction(String string, Predicate predicate, String string2) {
        super(string, predicate);
        this.setField(string2);
    }

    public ColorAction(String string, Predicate predicate, String string2, int n) {
        this(string, predicate, string2);
        this.setDefaultColor(n);
    }

    public void setField(String string) {
        this.m_colorField = string;
        this.m_startField = PrefuseLib.getStartField(string);
        this.m_endField = PrefuseLib.getEndField(string);
    }

    public int getDefaultColor() {
        return this.m_defaultColor;
    }

    public void setDefaultColor(int n) {
        this.m_defaultColor = n;
    }

    public void add(Predicate predicate, int n) {
        super.add(predicate, new Integer(n));
    }

    public void add(String string, int n) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        this.add(predicate, n);
    }

    public void add(Predicate predicate, ColorAction colorAction) {
        super.add(predicate, colorAction);
    }

    public void add(String string, ColorAction colorAction) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        super.add(predicate, colorAction);
    }

    public void process(VisualItem visualItem, double d) {
        int n = this.getColor(visualItem);
        int n2 = visualItem.getInt(this.m_colorField);
        visualItem.setInt(this.m_startField, n2);
        visualItem.setInt(this.m_endField, n);
        visualItem.setInt(this.m_colorField, n);
    }

    public int getColor(VisualItem visualItem) {
        Object object = this.lookup(visualItem);
        if (object != null) {
            if (object instanceof ColorAction) {
                return ((ColorAction)object).getColor(visualItem);
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        return this.m_defaultColor;
    }
}

