/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.time;

import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.modules.time.PyTimeTuple;
import org.python.modules.time.TimeFunctions;

public class Time
implements ClassDictInit {
    public static PyString __doc__ = new PyString("This module provides various functions to manipulate time values.\n\nThere are two standard representations of time.  One is the number\nof seconds since the Epoch, in UTC (a.k.a. GMT).  It may be an integer\nor a floating point number (to represent fractions of seconds).\nThe Epoch is system-defined; on Unix, it is generally January 1st, 1970.\nThe actual value can be retrieved by calling gmtime(0).\n\nThe other representation is a tuple of 9 integers giving local time.\nThe tuple items are:\n  year (four digits, e.g. 1998)\n  month (1-12)\n  day (1-31)\n  hours (0-23)\n  minutes (0-59)\n  seconds (0-59)\n  weekday (0-6, Monday is 0)\n  Julian day (day in the year, 1-366)\n  DST (Daylight Savings Time) flag (-1, 0 or 1)\nIf the DST flag is 0, the time is given in the regular time zone;\nif it is 1, the time is given in the DST time zone;\nif it is -1, mktime() should guess based on the date and time.\n\nVariables:\n\ntimezone -- difference in seconds between UTC and local standard time\naltzone -- difference in  seconds between UTC and local DST time\ndaylight -- whether local time should reflect DST\ntzname -- tuple of (standard time zone name, DST time zone name)\n\nFunctions:\n\ntime() -- return current time in seconds since the Epoch as a float\nclock() -- return CPU time since process start as a float\nsleep() -- delay for a number of seconds given as a float\ngmtime() -- convert seconds since Epoch to UTC tuple\nlocaltime() -- convert seconds since Epoch to local time tuple\nasctime() -- convert time tuple to string\nctime() -- convert time in seconds to string\nmktime() -- convert local time tuple to seconds since Epoch\nstrftime() -- convert time tuple to string according to format specification\nstrptime() -- parse string to time tuple according to format specification\n");
    private static double __initialclock__ = 0.0;
    protected static Locale currentLocale = null;
    protected static DateFormatSymbols datesyms = new DateFormatSymbols();
    protected static String[] shortdays = null;
    protected static String[] shortmonths = null;
    private static String[] enshortdays = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private static String[] enshortmonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static int timezone;
    public static int altzone;
    public static int daylight;
    public static PyTuple tzname;
    public static final int accept2dyear = 0;

    public static void classDictInit(PyObject pyObject) {
        pyObject.__setitem__("time", (PyObject)new TimeFunctions("time", 0, 0));
        pyObject.__setitem__("clock", (PyObject)new TimeFunctions("clock", 1, 0));
        pyObject.__setitem__("struct_time", (PyObject)PyType.fromClass((Class)PyTimeTuple.class));
        TimeZone timeZone = TimeZone.getDefault();
        tzname = new PyTuple(new PyObject[]{new PyString(Time.getDisplayName(timeZone, false, 0)), new PyString(Time.getDisplayName(timeZone, true, 0))});
        daylight = timeZone.useDaylightTime() ? 1 : 0;
        timezone = -timeZone.getRawOffset() / 1000;
        altzone = timezone - Time.getDSTSavings(timeZone) / 1000;
    }

    public static double time() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double clock() {
        if (__initialclock__ == 0.0) {
            __initialclock__ = Time.time();
        }
        return Time.time() - __initialclock__;
    }

    private static void throwValueError(String string2) {
        throw new PyException(Py.ValueError, (PyObject)new PyString(string2));
    }

    private static int item(PyTuple pyTuple, int n) {
        int n2 = ((PyInteger)pyTuple.__getitem__(n).__int__()).getValue();
        boolean bl = true;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                bl = 1 <= n2 && n2 <= 12;
                break;
            }
            case 2: {
                bl = 1 <= n2 && n2 <= 31;
                break;
            }
            case 3: {
                bl = 0 <= n2 && n2 <= 23;
                break;
            }
            case 4: {
                bl = 0 <= n2 && n2 <= 59;
                break;
            }
            case 5: {
                bl = 0 <= n2 && n2 <= 59;
                break;
            }
            case 6: {
                bl = 0 <= n2 && n2 <= 6;
                break;
            }
            case 7: {
                bl = 1 <= n2 && n2 < 367;
                break;
            }
            case 8: {
                boolean bl2 = bl = -1 <= n2 && n2 <= 1;
            }
        }
        if (!bl) {
            String string2;
            switch (n) {
                case 1: {
                    string2 = "month out of range (1-12)";
                    break;
                }
                case 2: {
                    string2 = "day out of range (1-31)";
                    break;
                }
                case 3: {
                    string2 = "hour out of range (0-23)";
                    break;
                }
                case 4: {
                    string2 = "minute out of range (0-59)";
                    break;
                }
                case 5: {
                    string2 = "second out of range (0-59)";
                    break;
                }
                case 6: {
                    string2 = "day of week out of range (0-6)";
                    break;
                }
                case 7: {
                    string2 = "day of year out of range (1-366)";
                    break;
                }
                case 8: {
                    string2 = "daylight savings flag out of range (-1,0,1)";
                    break;
                }
                default: {
                    string2 = "ignore";
                }
            }
            Time.throwValueError(string2);
        }
        if (n == 1) {
            --n2;
        }
        return n2;
    }

    private static GregorianCalendar _tupletocal(PyTuple pyTuple) {
        return new GregorianCalendar(Time.item(pyTuple, 0), Time.item(pyTuple, 1), Time.item(pyTuple, 2), Time.item(pyTuple, 3), Time.item(pyTuple, 4), Time.item(pyTuple, 5));
    }

    public static double mktime(PyTuple pyTuple) {
        GregorianCalendar gregorianCalendar;
        try {
            gregorianCalendar = Time._tupletocal(pyTuple);
        }
        catch (PyException pyException) {
            pyException.type = Py.OverflowError;
            throw pyException;
        }
        int n = Time.item(pyTuple, 8);
        if (n == 0 || n == 1) {
            gregorianCalendar.set(16, n * Time.getDSTSavings(gregorianCalendar.getTimeZone()));
        }
        return (double)gregorianCalendar.getTime().getTime() / 1000.0;
    }

    protected static PyTimeTuple _timefields(double d, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        gregorianCalendar.setTime(new Date((long)(d * 1000.0)));
        int n = gregorianCalendar.get(7) - 2;
        if (n < 0) {
            n += 7;
        }
        boolean bl = timeZone.inDaylightTime(gregorianCalendar.getTime());
        return new PyTimeTuple(new PyObject[]{new PyInteger(gregorianCalendar.get(1)), new PyInteger(gregorianCalendar.get(2) + 1), new PyInteger(gregorianCalendar.get(5)), new PyInteger(gregorianCalendar.get(10) + 12 * gregorianCalendar.get(9)), new PyInteger(gregorianCalendar.get(12)), new PyInteger(gregorianCalendar.get(13)), new PyInteger(n), new PyInteger(gregorianCalendar.get(6)), new PyInteger(bl ? 1 : 0)});
    }

    public static PyTuple localtime() {
        return Time.localtime(Time.time());
    }

    public static PyTuple localtime(double d) {
        return Time._timefields(d, TimeZone.getDefault());
    }

    public static PyTuple gmtime() {
        return Time.gmtime(Time.time());
    }

    public static PyTuple gmtime(double d) {
        return Time._timefields(d, TimeZone.getTimeZone("GMT"));
    }

    public static String ctime() {
        return Time.ctime(Time.time());
    }

    public static String ctime(double d) {
        return Time.asctime(Time.localtime(d));
    }

    private static String _shortday(int n) {
        try {
            if (shortdays == null) {
                shortdays = new String[7];
                String[] stringArray = datesyms.getShortWeekdays();
                for (int i = 0; i < 6; ++i) {
                    Time.shortdays[i] = stringArray[i + 2];
                }
                Time.shortdays[6] = stringArray[1];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Time.throwValueError("day of week out of range (0-6)");
        }
        return shortdays[n];
    }

    private static String _shortmonth(int n) {
        try {
            if (shortmonths == null) {
                shortmonths = new String[12];
                String[] stringArray = datesyms.getShortMonths();
                for (int i = 0; i < 12; ++i) {
                    Time.shortmonths[i] = stringArray[i];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Time.throwValueError("month out of range (1-12)");
        }
        return shortmonths[n];
    }

    private static String _padint(int n, int n2) {
        String string2 = Integer.toString(n);
        int n3 = string2.length();
        if (n2 <= n3) {
            return string2;
        }
        if (n2 == n3 + 1) {
            return "0" + string2;
        }
        if (n2 == n3 + 2) {
            return "00" + string2;
        }
        char[] cArray = new char[n2 - n3];
        Arrays.fill(cArray, '0');
        return new String(cArray) + string2;
    }

    private static String _twodigit(int n) {
        return Time._padint(n, 2);
    }

    private static String _truncyear(int n) {
        String string2 = Time._padint(n, 4);
        return string2.substring(string2.length() - 2, string2.length());
    }

    public static String asctime() {
        return Time.asctime(Time.localtime());
    }

    public static String asctime(PyTuple pyTuple) {
        StringBuffer stringBuffer = new StringBuffer(25);
        stringBuffer.append(enshortdays[Time.item(pyTuple, 6)]).append(' ');
        stringBuffer.append(enshortmonths[Time.item(pyTuple, 1)]).append(' ');
        int n = Time.item(pyTuple, 2);
        if (n < 10) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(n).append(' ');
        stringBuffer.append(Time._twodigit(Time.item(pyTuple, 3))).append(':');
        stringBuffer.append(Time._twodigit(Time.item(pyTuple, 4))).append(':');
        stringBuffer.append(Time._twodigit(Time.item(pyTuple, 5))).append(' ');
        return stringBuffer.append(Time.item(pyTuple, 0)).toString();
    }

    public static String locale_asctime(PyTuple pyTuple) {
        Time.checkLocale();
        int n = Time.item(pyTuple, 6);
        int n2 = Time.item(pyTuple, 1);
        return Time._shortday(n) + " " + Time._shortmonth(n2) + " " + Time._twodigit(Time.item(pyTuple, 2)) + " " + Time._twodigit(Time.item(pyTuple, 3)) + ":" + Time._twodigit(Time.item(pyTuple, 4)) + ":" + Time._twodigit(Time.item(pyTuple, 5)) + " " + Time.item(pyTuple, 0);
    }

    public static void sleep(double d) {
        try {
            Thread.sleep((long)(d * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            throw new PyException(Py.KeyboardInterrupt, "interrupted sleep");
        }
    }

    public static String strftime(String string2) {
        return Time.strftime(string2, Time.localtime());
    }

    public static String strftime(String string2, PyTuple pyTuple) {
        Time.checkLocale();
        String string3 = "";
        int n = 0;
        GregorianCalendar gregorianCalendar = null;
        while (n < string2.length()) {
            int n2 = string2.indexOf("%", n);
            if (n2 < 0) {
                string3 = string3 + string2.substring(n);
                break;
            }
            if (n2 == string2.length() - 1) {
                string3 = string3 + "%";
                break;
            }
            string3 = string3 + string2.substring(n, n2);
            switch (string2.charAt(++n2)) {
                case 'a': {
                    int n3 = Time.item(pyTuple, 6);
                    string3 = string3 + Time._shortday(n3);
                    break;
                }
                case 'A': {
                    String[] stringArray = datesyms.getWeekdays();
                    int n3 = Time.item(pyTuple, 6);
                    if (0 <= n3 && n3 < 6) {
                        string3 = string3 + stringArray[n3 + 2];
                        break;
                    }
                    if (n3 == 6) {
                        string3 = string3 + stringArray[1];
                        break;
                    }
                    Time.throwValueError("day of week out of range (0 - 6)");
                    break;
                }
                case 'b': {
                    int n3 = Time.item(pyTuple, 1);
                    string3 = string3 + Time._shortmonth(n3);
                    break;
                }
                case 'B': {
                    String[] stringArray = datesyms.getMonths();
                    int n3 = Time.item(pyTuple, 1);
                    string3 = string3 + stringArray[n3];
                    break;
                }
                case 'c': {
                    string3 = string3 + Time.locale_asctime(pyTuple);
                    break;
                }
                case 'd': {
                    string3 = string3 + Time._twodigit(Time.item(pyTuple, 2));
                    break;
                }
                case 'H': {
                    string3 = string3 + Time._twodigit(Time.item(pyTuple, 3));
                    break;
                }
                case 'I': {
                    int n3 = Time.item(pyTuple, 3) % 12;
                    if (n3 == 0) {
                        n3 = 12;
                    }
                    string3 = string3 + Time._twodigit(n3);
                    break;
                }
                case 'j': {
                    string3 = string3 + Time._padint(Time.item(pyTuple, 7), 3);
                    break;
                }
                case 'm': {
                    string3 = string3 + Time._twodigit(Time.item(pyTuple, 1) + 1);
                    break;
                }
                case 'M': {
                    string3 = string3 + Time._twodigit(Time.item(pyTuple, 4));
                    break;
                }
                case 'p': {
                    int n3 = Time.item(pyTuple, 3);
                    String[] stringArray = datesyms.getAmPmStrings();
                    if (0 <= n3 && n3 < 12) {
                        string3 = string3 + stringArray[0];
                        break;
                    }
                    if (12 <= n3 && n3 < 24) {
                        string3 = string3 + stringArray[1];
                        break;
                    }
                    Time.throwValueError("hour out of range (0-23)");
                    break;
                }
                case 'S': {
                    string3 = string3 + Time._twodigit(Time.item(pyTuple, 5));
                    break;
                }
                case 'U': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = Time._tupletocal(pyTuple);
                    }
                    gregorianCalendar.setFirstDayOfWeek(1);
                    gregorianCalendar.setMinimalDaysInFirstWeek(7);
                    int n3 = gregorianCalendar.get(3);
                    if (gregorianCalendar.get(2) == 0 && n3 >= 52) {
                        n3 = 0;
                    }
                    string3 = string3 + Time._twodigit(n3);
                    break;
                }
                case 'w': {
                    int n3 = (Time.item(pyTuple, 6) + 1) % 7;
                    string3 = string3 + Time._twodigit(n3);
                    break;
                }
                case 'W': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = Time._tupletocal(pyTuple);
                    }
                    gregorianCalendar.setFirstDayOfWeek(2);
                    gregorianCalendar.setMinimalDaysInFirstWeek(7);
                    int n3 = gregorianCalendar.get(3);
                    if (gregorianCalendar.get(2) == 0 && n3 >= 52) {
                        n3 = 0;
                    }
                    string3 = string3 + Time._twodigit(n3);
                    break;
                }
                case 'x': {
                    string3 = string3 + Time._twodigit(Time.item(pyTuple, 1) + 1) + "/" + Time._twodigit(Time.item(pyTuple, 2)) + "/" + Time._truncyear(Time.item(pyTuple, 0));
                    break;
                }
                case 'X': {
                    string3 = string3 + Time._twodigit(Time.item(pyTuple, 3)) + ":" + Time._twodigit(Time.item(pyTuple, 4)) + ":" + Time._twodigit(Time.item(pyTuple, 5));
                    break;
                }
                case 'Y': {
                    string3 = string3 + Time._padint(Time.item(pyTuple, 0), 4);
                    break;
                }
                case 'y': {
                    string3 = string3 + Time._truncyear(Time.item(pyTuple, 0));
                    break;
                }
                case 'Z': {
                    if (gregorianCalendar == null) {
                        gregorianCalendar = Time._tupletocal(pyTuple);
                    }
                    string3 = string3 + Time.getDisplayName(gregorianCalendar.getTimeZone(), Time.item(pyTuple, 8) > 0, 0);
                    break;
                }
                case '%': {
                    string3 = string3 + "%";
                    break;
                }
                default: {
                    string3 = string3 + "%" + string2.charAt(n2);
                    ++n2;
                }
            }
            n = n2 + 1;
            ++n2;
        }
        return string3;
    }

    private static void checkLocale() {
        if (!Locale.getDefault().equals(currentLocale)) {
            currentLocale = Locale.getDefault();
            datesyms = new DateFormatSymbols(currentLocale);
            shortdays = null;
            shortmonths = null;
        }
    }

    private static String getDisplayName(TimeZone timeZone, boolean bl, int n) {
        String string2 = System.getProperty("java.version");
        if (string2.compareTo("1.2") >= 0) {
            try {
                Method method = timeZone.getClass().getMethod("getDisplayName", Boolean.TYPE, Integer.TYPE);
                return (String)method.invoke((Object)timeZone, new Boolean(bl), new Integer(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timeZone.getID();
    }

    private static int getDSTSavings(TimeZone timeZone) {
        String string2 = System.getProperty("java.version");
        if (string2.compareTo("1.2") >= 0) {
            try {
                Method method = timeZone.getClass().getMethod("getDSTSavings", null);
                return (Integer)method.invoke((Object)timeZone, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    static {
        altzone = -1;
        tzname = null;
    }
}

