/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.sort;

import java.util.Comparator;
import prefuse.Visualization;
import prefuse.visual.AggregateItem;
import prefuse.visual.DecoratorItem;
import prefuse.visual.EdgeItem;
import prefuse.visual.VisualItem;

public class ItemSorter
implements Comparator {
    protected static final int AGGREGATE = 0;
    protected static final int EDGE = 1;
    protected static final int ITEM = 2;
    protected static final int DECORATOR = 3;

    public int score(VisualItem visualItem) {
        int n = 2;
        if (visualItem instanceof EdgeItem) {
            n = 1;
        } else if (visualItem instanceof AggregateItem) {
            n = 0;
        } else if (visualItem instanceof DecoratorItem) {
            n = 3;
        }
        int n2 = 1 << 26 + n;
        if (visualItem.isHover()) {
            n2 += 0x2000000;
        }
        if (visualItem.isHighlighted()) {
            n2 += 0x1000000;
        }
        if (visualItem.isInGroup(Visualization.FOCUS_ITEMS)) {
            n2 += 0x800000;
        }
        if (visualItem.isInGroup(Visualization.SEARCH_ITEMS)) {
            n2 += 0x400000;
        }
        return n2;
    }

    public int compare(VisualItem visualItem, VisualItem visualItem2) {
        int n;
        int n2 = this.score(visualItem);
        return n2 < (n = this.score(visualItem2)) ? -1 : (n2 == n ? 0 : 1);
    }

    public int compare(Object object, Object object2) {
        if (!(object instanceof VisualItem) || !(object2 instanceof VisualItem)) {
            throw new IllegalArgumentException();
        }
        return this.compare((VisualItem)object, (VisualItem)object2);
    }
}

