/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.data.Table;
import prefuse.data.event.TableListener;
import prefuse.visual.VisualItem;

public class DragControl
extends ControlAdapter
implements TableListener {
    private VisualItem activeItem;
    protected String action;
    protected Point2D down = new Point2D.Double();
    protected Point2D temp = new Point2D.Double();
    protected boolean dragged;
    protected boolean wasFixed;
    protected boolean resetItem;
    private boolean fixOnMouseOver = true;
    protected boolean repaint = true;

    public DragControl() {
    }

    public DragControl(boolean bl) {
        this.repaint = bl;
    }

    public DragControl(boolean bl, boolean bl2) {
        this.repaint = bl;
        this.fixOnMouseOver = bl2;
    }

    public DragControl(String string) {
        this.repaint = false;
        this.action = string;
    }

    public DragControl(String string, boolean bl) {
        this.repaint = false;
        this.fixOnMouseOver = bl;
        this.action = string;
    }

    public void setFixPositionOnMouseOver(boolean bl) {
        this.fixOnMouseOver = bl;
    }

    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getPredefinedCursor(12));
        this.activeItem = visualItem;
        if (this.fixOnMouseOver) {
            this.wasFixed = visualItem.isFixed();
            this.resetItem = true;
            visualItem.setFixed(true);
            visualItem.getTable().addTableListener(this);
        }
    }

    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.activeItem == visualItem) {
            this.activeItem = null;
            visualItem.getTable().removeTableListener(this);
            if (this.resetItem) {
                visualItem.setFixed(this.wasFixed);
            }
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getDefaultCursor());
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!this.fixOnMouseOver) {
            this.wasFixed = visualItem.isFixed();
            this.resetItem = true;
            visualItem.setFixed(true);
            visualItem.getTable().addTableListener(this);
        }
        this.dragged = false;
        Display display = (Display)mouseEvent.getComponent();
        display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.down);
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.dragged) {
            this.activeItem = null;
            visualItem.getTable().removeTableListener(this);
            if (this.resetItem) {
                visualItem.setFixed(this.wasFixed);
            }
            this.dragged = false;
        }
    }

    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.dragged = true;
        Display display = (Display)mouseEvent.getComponent();
        display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.temp);
        double d = this.temp.getX() - this.down.getX();
        double d2 = this.temp.getY() - this.down.getY();
        double d3 = visualItem.getX();
        double d4 = visualItem.getY();
        visualItem.setStartX(d3);
        visualItem.setStartY(d4);
        visualItem.setX(d3 + d);
        visualItem.setY(d4 + d2);
        visualItem.setEndX(d3 + d);
        visualItem.setEndY(d4 + d2);
        if (this.repaint) {
            visualItem.getVisualization().repaint();
        }
        this.down.setLocation(this.temp);
        if (this.action != null) {
            display.getVisualization().run(this.action);
        }
    }

    public void tableChanged(Table table, int n, int n2, int n3, int n4) {
        if (this.activeItem == null || n4 != 0 || n3 != table.getColumnNumber(VisualItem.FIXED)) {
            return;
        }
        int n5 = this.activeItem.getRow();
        if (n5 >= n && n5 <= n2) {
            this.resetItem = false;
        }
    }
}

