/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyDescriptor;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyType;

public class PyMethodDescr
extends PyDescriptor
implements PyBuiltinFunction.Info {
    protected int minargs;
    protected int maxargs;
    protected PyBuiltinFunction meth;

    public PyMethodDescr(String string, Class clazz, int n, int n2, PyBuiltinFunction pyBuiltinFunction) {
        this.name = string;
        this.dtype = PyType.fromClass(clazz);
        this.minargs = n;
        this.maxargs = n2;
        this.meth = pyBuiltinFunction;
        this.meth.setInfo(this);
    }

    public String getName() {
        return this.name;
    }

    public int getMaxargs() {
        return this.maxargs;
    }

    public int getMinargs() {
        return this.minargs;
    }

    public String toString() {
        return "<method '" + this.name + "' of '" + this.dtype.fastGetName() + "' objects>";
    }

    public PyObject __call__(PyObject[] pyObjectArray) {
        return this.__call__(pyObjectArray, Py.NoKeywords);
    }

    public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
        if (pyObjectArray.length == stringArray.length) {
            throw Py.TypeError(this.name + " requires at least one argument");
        }
        this.checkCallerType(pyObjectArray[0]);
        PyObject[] pyObjectArray2 = new PyObject[pyObjectArray.length - 1];
        System.arraycopy(pyObjectArray, 1, pyObjectArray2, 0, pyObjectArray2.length);
        return this.meth.bind(pyObjectArray[0]).__call__(pyObjectArray2, stringArray);
    }

    public PyException unexpectedCall(int n, boolean bl) {
        return PyBuiltinFunction.DefaultInfo.unexpectedCall(n, bl, this.name, this.minargs, this.maxargs);
    }

    public PyObject __get__(PyObject pyObject, PyObject pyObject2) {
        if (pyObject != null) {
            this.checkCallerType(pyObject);
            return this.meth.bind(pyObject);
        }
        return this;
    }

    protected void checkCallerType(PyObject pyObject) {
        PyType pyType = pyObject.getType();
        if (pyType != this.dtype && !pyType.isSubType(this.dtype)) {
            throw this.get_wrongtype(pyType);
        }
    }
}

