/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import prefuse.data.Tuple;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.search.Trie;

public class PrefixIntersectionSearchTupleSet
extends SearchTupleSet {
    private Trie m_trie;
    private Trie.TrieNode m_curNode;
    private String m_delim = " _\t\n\r";
    private String m_query = "";
    private String m_field = null;

    public PrefixIntersectionSearchTupleSet() {
        this(false);
    }

    public PrefixIntersectionSearchTupleSet(boolean caseSensitive) {
        this.m_trie = new Trie(caseSensitive);
    }

    public String getDelimiterString() {
        return this.m_delim;
    }

    public void setDelimiterString(String delim) {
        this.m_delim = delim;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void search(String query) {
        if (query == null) {
            query = "";
        }
        if (query.equals(this.m_query)) {
            return;
        }
        Tuple[] rem = this.clearInternal();
        this.m_query = query;
        if (query.startsWith("=")) {
            this.exactSearch(query.substring(1));
        } else {
            StringTokenizer st = new StringTokenizer(this.m_query, this.m_delim);
            if (!st.hasMoreTokens()) {
                this.m_query = "";
            }
            boolean firstTime = true;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                this.prefixSearch(tok, firstTime);
                firstTime = false;
            }
        }
        Tuple[] add = this.getTupleCount() > 0 ? this.toArray() : null;
        this.fireTupleEvent(add, rem);
    }

    private void exactSearch(String query) {
        this.m_curNode = this.m_trie.find(query);
        if (this.m_curNode != null) {
            Iterator iter = this.trieIterator();
            while (iter.hasNext()) {
                Tuple t = (Tuple)iter.next();
                if (!t.getString(this.m_field).equalsIgnoreCase(query)) continue;
                this.addInternal(t);
                break;
            }
        }
    }

    private void prefixSearch(String query, boolean init) {
        block7: {
            block6: {
                if (!init) break block6;
                this.m_curNode = this.m_trie.find(query);
                if (this.m_curNode == null) break block7;
                Iterator iter = this.trieIterator();
                while (iter.hasNext()) {
                    this.addInternal((Tuple)iter.next());
                }
                break block7;
            }
            this.m_curNode = this.m_trie.find(query);
            if (this.m_curNode == null) {
                this.clearInternal();
            } else {
                HashSet<Tuple> hset = new HashSet<Tuple>();
                Iterator iter = this.trieIterator();
                while (iter.hasNext()) {
                    hset.add((Tuple)iter.next());
                }
                Iterator titer = this.tuples();
                Vector<Tuple> toRemove = new Vector<Tuple>();
                while (titer.hasNext()) {
                    Tuple t = (Tuple)titer.next();
                    if (hset.contains(t)) continue;
                    toRemove.add(t);
                }
                Iterator riter = toRemove.iterator();
                while (riter.hasNext()) {
                    this.removeInternal((Tuple)riter.next());
                }
            }
        }
    }

    public void index(Tuple t, String field) {
        this.m_field = field;
        String s = t.getString(field);
        if (s == null) {
            return;
        }
        this.addString("*", t);
        this.addString(s, t);
        StringTokenizer st = new StringTokenizer(s, this.m_delim);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals(s)) continue;
            this.addString(tok, t);
        }
    }

    private void addString(String s, Tuple t) {
        this.m_trie.addString(s, t);
    }

    public boolean isUnindexSupported() {
        return true;
    }

    public void unindex(Tuple t, String field) {
        String s = t.getString(field);
        if (s == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, this.m_delim);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            this.removeString(tok, t);
        }
    }

    public void clear() {
        this.m_trie = new Trie(this.m_trie.isCaseSensitive());
        super.clear();
    }

    private void removeString(String s, Tuple t) {
        this.m_trie.removeString(s, t);
    }

    private Iterator trieIterator() {
        Trie trie = this.m_trie;
        trie.getClass();
        return new Trie.TrieIterator(trie, this.m_curNode);
    }
}

