/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;

public class GravitationalForce
extends AbstractForce {
    private static final String[] pnames = new String[]{"GravitationalConstant", "Direction"};
    public static final int GRAVITATIONAL_CONST = 0;
    public static final int DIRECTION = 1;
    public static final float DEFAULT_FORCE_CONSTANT = 1.0E-4f;
    public static final float DEFAULT_MIN_FORCE_CONSTANT = 1.0E-5f;
    public static final float DEFAULT_MAX_FORCE_CONSTANT = 0.001f;
    public static final float DEFAULT_DIRECTION = -1.5707964f;
    public static final float DEFAULT_MIN_DIRECTION = (float)(-Math.PI);
    public static final float DEFAULT_MAX_DIRECTION = (float)Math.PI;

    public GravitationalForce(float f, float f2) {
        this.params = new float[]{f, f2};
        this.minValues = new float[]{1.0E-5f, (float)(-Math.PI)};
        this.maxValues = new float[]{0.001f, (float)Math.PI};
    }

    public GravitationalForce() {
        this(1.0E-4f, -1.5707964f);
    }

    public boolean isItemForce() {
        return true;
    }

    protected String[] getParameterNames() {
        return pnames;
    }

    public void getForce(ForceItem forceItem) {
        float f = this.params[1];
        float f2 = this.params[0] * forceItem.mass;
        forceItem.force[0] = (float)((double)forceItem.force[0] + Math.cos(f) * (double)f2);
        forceItem.force[1] = (float)((double)forceItem.force[1] + Math.sin(f) * (double)f2);
    }
}

