/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import prefuse.data.io.sql.DatabaseDataSource;
import prefuse.data.io.sql.DefaultSQLDataHandler;
import prefuse.data.io.sql.SQLDataHandler;

public class ConnectionFactory {
    public static final String DRIVER_MYSQL = "com.mysql.jdbc.Driver";
    public static final String DRIVER_JDBC_OBDC = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String PROTOCOL_JDBC = "jdbc:";
    public static final String SUBPROTOCOL_MYSQL = "mysql:";
    public static final String SUBPROTOCOL_JDBC_ODBC = "odbc:";

    public static SQLDataHandler getDefaultHandler() {
        return new DefaultSQLDataHandler();
    }

    public static DatabaseDataSource getDatabaseConnection(Connection connection, SQLDataHandler sQLDataHandler) throws SQLException {
        return new DatabaseDataSource(connection, sQLDataHandler);
    }

    public static DatabaseDataSource getDatabaseConnection(Connection connection) throws SQLException {
        return ConnectionFactory.getDatabaseConnection(connection, ConnectionFactory.getDefaultHandler());
    }

    public static DatabaseDataSource getDatabaseConnection(String string, String string2, String string3, String string4, SQLDataHandler sQLDataHandler) throws SQLException, ClassNotFoundException {
        Class.forName(string);
        Connection connection = DriverManager.getConnection(string2, string3, string4);
        return ConnectionFactory.getDatabaseConnection(connection, sQLDataHandler);
    }

    public static DatabaseDataSource getDatabaseConnection(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        return ConnectionFactory.getDatabaseConnection(string, string2, string3, string4, ConnectionFactory.getDefaultHandler());
    }

    public static DatabaseDataSource getMySQLConnection(String string, String string2, String string3, String string4, SQLDataHandler sQLDataHandler) throws SQLException, ClassNotFoundException {
        String string5 = "jdbc:mysql://" + string + "/" + string2;
        return ConnectionFactory.getDatabaseConnection(DRIVER_MYSQL, string5, string3, string4, sQLDataHandler);
    }

    public static DatabaseDataSource getMySQLConnection(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        return ConnectionFactory.getMySQLConnection(string, string2, string3, string4, ConnectionFactory.getDefaultHandler());
    }
}

