/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.io;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.io.CSVTableReader;
import prefuse.data.io.DelimitedTextTableReader;
import prefuse.data.io.GraphMLReader;
import prefuse.data.io.GraphReader;
import prefuse.data.io.TableReader;
import prefuse.data.io.TreeMLReader;
import prefuse.util.StringLib;
import prefuse.util.collections.ByteArrayList;
import prefuse.util.io.SimpleFileFilter;

public class IOLib {
    private IOLib() {
    }

    public static boolean isUrlString(String string) {
        return string.startsWith("http:/") || string.startsWith("ftp:/") || string.startsWith("file:/");
    }

    public static URL urlFromString(String string) {
        return IOLib.urlFromString(string, null, true);
    }

    public static URL urlFromString(String string, Class clazz, boolean bl) {
        URL uRL = null;
        if (IOLib.isUrlString(string)) {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            uRL = clazz != null ? clazz.getResource(string) : IOLib.class.getResource(string);
            if (uRL == null && !string.startsWith("/")) {
                uRL = IOLib.class.getResource("/" + string);
            }
            if (bl && uRL == null && new File(string).exists()) {
                try {
                    uRL = new URL("file:///" + string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return uRL;
    }

    public static InputStream streamFromString(String string) throws IOException {
        InputStream inputStream = null;
        URL uRL = IOLib.urlFromString(string, null, false);
        if (uRL != null) {
            inputStream = uRL.openStream();
        } else {
            File file = new File(string);
            if (file.exists()) {
                inputStream = new FileInputStream(file);
            }
        }
        if (inputStream == null) {
            return null;
        }
        if (IOLib.isGZipFile(string)) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static String getExtension(File file) {
        return file != null ? IOLib.getExtension(file.getName()) : null;
    }

    public static boolean isGZipFile(String string) {
        String string2 = IOLib.getExtension(string);
        return "gz".equals(string2) || "z".equals(string2);
    }

    public static boolean isZipFile(String string) {
        return "zip".equals(IOLib.getExtension(string));
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public static ByteArrayList readAsBytes(InputStream inputStream) throws IOException {
        ByteArrayList byteArrayList = new ByteArrayList();
        byte[] byArray = new byte[8192];
        int n = -1;
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayList.add(byArray, 0, n);
        }
        return byteArrayList;
    }

    public static String readAsString(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[8192];
        int n = -1;
        while ((n = inputStream.read(byArray)) >= 0) {
            String string = new String(byArray, 0, n);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String readAsString(String string) throws IOException {
        return IOLib.readAsString(IOLib.streamFromString(string));
    }

    public static Table getTableFile(Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle("Open Table File");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter("csv", "Comma Separated Values (CSV) File (*.csv)", new CSVTableReader());
        simpleFileFilter.addExtension("gz");
        jFileChooser.setFileFilter(simpleFileFilter);
        simpleFileFilter = new SimpleFileFilter("txt", "Pipe-Delimited Text File (*.txt)", new DelimitedTextTableReader("|"));
        simpleFileFilter.addExtension("gz");
        jFileChooser.setFileFilter(simpleFileFilter);
        simpleFileFilter = new SimpleFileFilter("txt", "Tab-Delimited Text File (*.txt)", new DelimitedTextTableReader());
        simpleFileFilter.addExtension("gz");
        jFileChooser.setFileFilter(simpleFileFilter);
        int n = jFileChooser.showOpenDialog(component);
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        simpleFileFilter = (SimpleFileFilter)jFileChooser.getFileFilter();
        TableReader tableReader = (TableReader)simpleFileFilter.getUserData();
        try {
            return tableReader.readTable(IOLib.streamFromString(file.getAbsolutePath()));
        }
        catch (Exception exception) {
            Logger.getLogger(IOLib.class.getName()).warning(exception.getMessage() + "\n" + StringLib.getStackTrace(exception));
            return null;
        }
    }

    public static Graph getGraphFile(Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle("Open Graph or Tree File");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter("xml", "TreeML File (*.xml, *.treeml)", new TreeMLReader());
        simpleFileFilter.addExtension("treeml");
        simpleFileFilter.addExtension("gz");
        jFileChooser.setFileFilter(simpleFileFilter);
        simpleFileFilter = new SimpleFileFilter("xml", "GraphML File (*.xml, *.graphml)", new GraphMLReader());
        simpleFileFilter.addExtension("graphml");
        simpleFileFilter.addExtension("gz");
        jFileChooser.setFileFilter(simpleFileFilter);
        int n = jFileChooser.showOpenDialog(component);
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        simpleFileFilter = (SimpleFileFilter)jFileChooser.getFileFilter();
        GraphReader graphReader = (GraphReader)simpleFileFilter.getUserData();
        try {
            return graphReader.readGraph(IOLib.streamFromString(file.getAbsolutePath()));
        }
        catch (Exception exception) {
            Logger.getLogger(IOLib.class.getName()).warning(exception.getMessage() + "\n" + StringLib.getStackTrace(exception));
            return null;
        }
    }
}

