/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.BinaryExpression;
import prefuse.data.expression.Expression;
import prefuse.util.TypeLib;

public class ArithmeticExpression
extends BinaryExpression {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int POW = 4;
    public static final int MOD = 5;
    private Class m_type = null;

    public ArithmeticExpression(int n, Expression expression, Expression expression2) {
        super(n, 0, 5, expression, expression2);
    }

    public Class getType(Schema schema) {
        if (this.m_type == null) {
            Class clazz = this.m_left.getType(schema);
            Class clazz2 = this.m_right.getType(schema);
            this.m_type = TypeLib.getNumericType(clazz, clazz2);
        }
        return this.m_type;
    }

    public Object get(Tuple tuple) {
        Class clazz = this.getType(tuple.getSchema());
        if (Integer.TYPE == clazz || Byte.TYPE == clazz) {
            return new Integer(this.getInt(tuple));
        }
        if (Long.TYPE == clazz) {
            return new Long(this.getInt(tuple));
        }
        if (Float.TYPE == clazz) {
            return new Float(this.getFloat(tuple));
        }
        if (Double.TYPE == clazz) {
            return new Double(this.getDouble(tuple));
        }
        throw new IllegalStateException();
    }

    public int getInt(Tuple tuple) {
        int n = this.m_left.getInt(tuple);
        int n2 = this.m_right.getInt(tuple);
        switch (this.m_op) {
            case 0: {
                return n + n2;
            }
            case 1: {
                return n - n2;
            }
            case 2: {
                return n * n2;
            }
            case 3: {
                return n / n2;
            }
            case 4: {
                return (int)Math.pow(n, n2);
            }
            case 5: {
                return n % n2;
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public long getLong(Tuple tuple) {
        long l = this.m_left.getLong(tuple);
        long l2 = this.m_right.getLong(tuple);
        switch (this.m_op) {
            case 0: {
                return l + l2;
            }
            case 1: {
                return l - l2;
            }
            case 2: {
                return l * l2;
            }
            case 3: {
                return l / l2;
            }
            case 4: {
                return (long)Math.pow(l, l2);
            }
            case 5: {
                return l % l2;
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public float getFloat(Tuple tuple) {
        float f = this.m_left.getFloat(tuple);
        float f2 = this.m_right.getFloat(tuple);
        switch (this.m_op) {
            case 0: {
                return f + f2;
            }
            case 1: {
                return f - f2;
            }
            case 2: {
                return f * f2;
            }
            case 3: {
                return f / f2;
            }
            case 4: {
                return (float)Math.pow(f, f2);
            }
            case 5: {
                return (float)Math.IEEEremainder(f, f2);
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public double getDouble(Tuple tuple) {
        double d = this.m_left.getDouble(tuple);
        double d2 = this.m_right.getDouble(tuple);
        switch (this.m_op) {
            case 0: {
                return d + d2;
            }
            case 1: {
                return d - d2;
            }
            case 2: {
                return d * d2;
            }
            case 3: {
                return d / d2;
            }
            case 4: {
                return Math.pow(d, d2);
            }
            case 5: {
                return Math.IEEEremainder(d, d2);
            }
        }
        throw new IllegalStateException("Unknown operation type.");
    }

    public String toString() {
        char c = '?';
        switch (this.m_op) {
            case 0: {
                c = '+';
                break;
            }
            case 1: {
                c = '-';
                break;
            }
            case 2: {
                c = '*';
                break;
            }
            case 3: {
                c = '/';
                break;
            }
            case 4: {
                c = '^';
                break;
            }
            case 5: {
                c = '%';
            }
        }
        return '(' + this.m_left.toString() + ' ' + c + ' ' + this.m_right.toString() + ')';
    }
}

