/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import java.util.ArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import prefuse.util.collections.CopyOnWriteArrayList;

public class ListModel
extends DefaultListSelectionModel
implements MutableComboBoxModel {
    private ArrayList m_items = new ArrayList();
    private CopyOnWriteArrayList m_lstnrs = new CopyOnWriteArrayList();

    public ListModel() {
    }

    public ListModel(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_items.add(objectArray[i]);
        }
    }

    private boolean isMultipleSelection() {
        return this.getMaxSelectionIndex() - this.getMinSelectionIndex() > 0;
    }

    public Object getSelectedItem() {
        int n = this.getMinSelectionIndex();
        return n == -1 ? null : this.m_items.get(n);
    }

    public void setSelectedItem(Object object) {
        int n = this.m_items.indexOf(object);
        if (n < 0) {
            return;
        }
        if (!this.isMultipleSelection() && n == this.getMinSelectionIndex()) {
            return;
        }
        super.setSelectionInterval(n, n);
        this.fireDataEvent(this, 0, -1, -1);
    }

    public int getSize() {
        return this.m_items.size();
    }

    public Object getElementAt(int n) {
        return this.m_items.get(n);
    }

    public void addElement(Object object) {
        this.m_items.add(object);
        int n = this.m_items.size() - 1;
        this.fireDataEvent(this, 1, n, n);
        if (n >= 0 && this.isSelectionEmpty() && object != null) {
            this.setSelectedItem(object);
        }
    }

    public void insertElementAt(Object object, int n) {
        this.m_items.add(n, object);
        this.fireDataEvent(this, 1, n, n);
    }

    public void removeElement(Object object) {
        int n = this.m_items.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
        }
    }

    public void removeElementAt(int n) {
        if (!this.isMultipleSelection() && n == this.getMinSelectionIndex()) {
            int n2 = n == 0 ? (this.getSize() == 1 ? -1 : n + 1) : n - 1;
            Object var3_3 = n2 == -1 ? null : this.m_items.get(n2);
            this.setSelectedItem(var3_3);
        }
        this.m_items.remove(n);
        this.fireDataEvent(this, 2, n, n);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        if (!this.m_lstnrs.contains(listDataListener)) {
            this.m_lstnrs.add(listDataListener);
        }
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.m_lstnrs.remove(listDataListener);
    }

    protected void fireDataEvent(Object object, int n, int n2, int n3) {
        Object[] objectArray = this.m_lstnrs.getArray();
        if (objectArray.length > 0) {
            ListDataEvent listDataEvent = new ListDataEvent(object, n, n2, n3);
            for (int i = 0; i < objectArray.length; ++i) {
                ((ListDataListener)objectArray[i]).contentsChanged(listDataEvent);
            }
        }
    }
}

