/*
 * Decompiled with CFR 0.152.
 */
package prefuse.activity;

import java.util.HashMap;
import prefuse.activity.Activity;
import prefuse.activity.ActivityManager;

public class ActivityMap {
    private HashMap m_map = new HashMap();
    private ActivityMap m_parent;

    public ActivityMap() {
        this(null);
    }

    public ActivityMap(ActivityMap activityMap) {
        this.m_parent = activityMap;
    }

    public void clear() {
        this.m_map.clear();
    }

    public int size() {
        return this.m_map.size();
    }

    public Activity get(String string) {
        Activity activity = (Activity)this.m_map.get(string);
        return activity == null && this.m_parent != null ? this.m_parent.get(string) : activity;
    }

    public Activity runAt(String string, long l) {
        Activity activity = this.get(string);
        if (activity != null) {
            ActivityManager.scheduleAt(activity, l);
        }
        return activity;
    }

    public Activity run(String string) {
        Activity activity = this.get(string);
        if (activity != null) {
            ActivityManager.scheduleNow(activity);
        }
        return activity;
    }

    public Activity runAfter(String string, String string2) {
        Activity activity = this.get(string);
        Activity activity2 = this.get(string2);
        if (activity != null && activity2 != null) {
            ActivityManager.scheduleAfter(activity, activity2);
        }
        return activity2;
    }

    public Activity alwaysRunAfter(String string, String string2) {
        Activity activity = this.get(string);
        Activity activity2 = this.get(string2);
        if (activity != null && activity2 != null) {
            ActivityManager.alwaysScheduleAfter(activity, activity2);
        }
        return activity2;
    }

    public Activity cancel(String string) {
        Activity activity = this.get(string);
        if (activity != null) {
            activity.cancel();
        }
        return activity;
    }

    public Activity put(String string, Activity activity) {
        return this.m_map.put(string, activity);
    }

    public void remove(Object object) {
        this.m_map.remove(object);
    }

    public Object[] keys() {
        return this.m_map.keySet().toArray();
    }

    public Object[] allKeys() {
        Object[] objectArray;
        Object[] objectArray2 = this.m_map.keySet().toArray();
        if (this.m_parent != null && (objectArray = this.m_parent.allKeys()) != null && objectArray.length > 0) {
            Object[] objectArray3 = new Object[objectArray2.length + objectArray.length];
            System.arraycopy(objectArray2, 0, objectArray3, 0, objectArray2.length);
            System.arraycopy(objectArray, 0, objectArray3, objectArray2.length, objectArray.length);
            return objectArray3;
        }
        return objectArray2;
    }

    public void setParent(ActivityMap activityMap) {
        this.m_parent = activityMap;
    }

    public ActivityMap getParent() {
        return this.m_parent;
    }
}

