/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import prefuse.util.ui.UILib;

public class JToggleGroup
extends JPanel {
    public static final int CHECKBOX = 0;
    public static final int RADIO = 1;
    protected final int m_type;
    protected int m_margin = 0;
    protected int m_spacing = 0;
    protected int m_axis = 0;
    protected ListModel m_data;
    protected ListSelectionModel m_sel;
    protected String[] m_labels;
    protected ButtonGroup m_group;
    private Listener m_lstnr;

    public JToggleGroup(int n, Object[] objectArray) {
        this(n, new DefaultListModel(), new DefaultListSelectionModel());
        DefaultListModel defaultListModel = (DefaultListModel)this.m_data;
        for (int i = 0; i < objectArray.length; ++i) {
            defaultListModel.addElement(objectArray[i]);
        }
        this.initUI();
    }

    public JToggleGroup(int n, ListModel listModel) {
        this(n, listModel, new DefaultListSelectionModel());
    }

    public JToggleGroup(int n, ListModel listModel, ListSelectionModel listSelectionModel) {
        this.setLayout(new BoxLayout(this, this.m_axis));
        this.m_type = n;
        this.m_data = listModel;
        this.m_sel = listSelectionModel;
        if (this.m_type == 1) {
            this.m_group = new ButtonGroup();
        }
        this.m_lstnr = new Listener();
        this.m_sel.addListSelectionListener(this.m_lstnr);
        if (this.m_data.getSize() > 0) {
            this.initUI();
        }
        this.setFocusable(false);
    }

    protected void initUI() {
        Object object;
        Component component;
        int n;
        for (n = 0; n < this.getComponentCount(); ++n) {
            component = this.getComponent(n);
            if (!(component instanceof JToggleButton)) continue;
            object = (JToggleButton)component;
            ((AbstractButton)object).removeActionListener(this.m_lstnr);
            if (this.m_group == null) continue;
            this.m_group.remove((AbstractButton)object);
        }
        this.removeAll();
        UILib.addStrut((JComponent)this, this.m_axis, this.m_margin);
        for (n = 0; n < this.m_data.getSize(); ++n) {
            if (n > 0) {
                UILib.addStrut((JComponent)this, this.m_axis, this.m_spacing);
            }
            component = this.m_data.getElementAt(n);
            object = this.m_labels == null ? ((Object)component).toString() : this.m_labels[n];
            JToggleButton jToggleButton = null;
            if (this.m_type == 0) {
                jToggleButton = new JCheckBox((String)object);
            } else {
                jToggleButton = new JRadioButton((String)object);
                this.m_group.add(jToggleButton);
            }
            jToggleButton.putClientProperty("idx", new Integer(n));
            jToggleButton.addActionListener(this.m_lstnr);
            this.add(jToggleButton);
        }
        UILib.addStrut((JComponent)this, this.m_axis, this.m_margin);
        this.m_lstnr.valueChanged(null);
    }

    public void setAxisType(int n) {
        this.setLayout(new BoxLayout(this, n));
        this.m_axis = n;
        this.initUI();
    }

    public int getAxisType() {
        return this.m_axis;
    }

    public void setMargin(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Margin is less than zero.");
        }
        this.m_margin = n;
        this.initUI();
    }

    public int getMargin() {
        return this.m_margin;
    }

    public void setSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Spacing is less than zero.");
        }
        this.m_spacing = n;
        this.initUI();
    }

    public int getSpacing() {
        return this.m_spacing;
    }

    public void setModel(ListModel listModel) {
        this.m_data = listModel;
        this.initUI();
    }

    public ListModel getModel() {
        return this.m_data;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        this.m_sel.removeListSelectionListener(this.m_lstnr);
        this.m_sel = listSelectionModel;
        this.m_sel.addListSelectionListener(this.m_lstnr);
        this.m_lstnr.valueChanged(null);
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_sel;
    }

    public void setLabels(String[] stringArray) {
        if (stringArray.length < this.m_data.getSize()) {
            throw new IllegalArgumentException("Alias array is too short");
        }
        this.m_labels = stringArray;
        this.initUI();
    }

    public void setBackground(Color color) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setBackground(color);
        }
    }

    public void setForeground(Color color) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setForeground(color);
        }
    }

    public void setFont(Font font) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setFont(font);
        }
    }

    public void setGroupFocusable(boolean bl) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JToggleButton)) continue;
            component.setFocusable(bl);
        }
    }

    private class Listener
    implements ListSelectionListener,
    ActionListener {
        private boolean m_ignore = false;

        private Listener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.m_ignore) {
                return;
            }
            this.m_ignore = true;
            if (JToggleGroup.this.m_type == 1) {
                int n = JToggleGroup.this.m_sel.getMinSelectionIndex();
                boolean bl = n >= 0;
                AbstractButton abstractButton = null;
                int n2 = 0;
                for (int i = 0; i < JToggleGroup.this.getComponentCount(); ++i) {
                    Component component = JToggleGroup.this.getComponent(i);
                    if (!(component instanceof JToggleButton)) continue;
                    abstractButton = (JToggleButton)component;
                    if (!bl && abstractButton.isSelected() || bl && n == n2) break;
                    ++n2;
                }
                abstractButton.setSelected(bl);
            } else {
                int n = 0;
                for (int i = 0; i < JToggleGroup.this.getComponentCount(); ++i) {
                    Component component = JToggleGroup.this.getComponent(i);
                    if (!(component instanceof JCheckBox)) continue;
                    ((JCheckBox)component).setSelected(JToggleGroup.this.m_sel.isSelectedIndex(n++));
                }
            }
            this.m_ignore = false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.m_ignore) {
                return;
            }
            this.m_ignore = true;
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            boolean bl = jToggleButton.isSelected();
            int n = (Integer)jToggleButton.getClientProperty("idx");
            if (JToggleGroup.this.m_type == 1) {
                JToggleGroup.this.m_sel.setSelectionInterval(n, n);
            } else if (bl) {
                JToggleGroup.this.m_sel.addSelectionInterval(n, n);
            } else {
                JToggleGroup.this.m_sel.removeSelectionInterval(n, n);
            }
            this.m_ignore = false;
        }
    }
}

