/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.util.force.Force;
import prefuse.util.force.ForceSimulator;
import prefuse.util.ui.JValueSlider;

public class JForcePanel
extends JPanel {
    private ForcePanelChangeListener lstnr = new ForcePanelChangeListener();
    private ForceSimulator fsim;

    public JForcePanel(ForceSimulator forceSimulator) {
        this.fsim = forceSimulator;
        this.setBackground(Color.WHITE);
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BoxLayout(this, 1));
        Force[] forceArray = this.fsim.getForces();
        for (int i = 0; i < forceArray.length; ++i) {
            Force force = forceArray[i];
            Box box = new Box(1);
            for (int j = 0; j < force.getParameterCount(); ++j) {
                JValueSlider jValueSlider = JForcePanel.createField(force, j);
                jValueSlider.addChangeListener(this.lstnr);
                box.add(jValueSlider);
            }
            String string = force.getClass().getName();
            string = string.substring(string.lastIndexOf(".") + 1);
            box.setBorder(BorderFactory.createTitledBorder(string));
            this.add(box);
        }
    }

    private static JValueSlider createField(Force force, int n) {
        double d = force.getParameter(n);
        double d2 = force.getMinValue(n);
        double d3 = force.getMaxValue(n);
        String string = force.getParameterName(n);
        JValueSlider jValueSlider = new JValueSlider(string, d2, d3, d);
        jValueSlider.setBackground(Color.WHITE);
        jValueSlider.putClientProperty("force", force);
        jValueSlider.putClientProperty("param", new Integer(n));
        jValueSlider.setPreferredSize(new Dimension(300, 30));
        jValueSlider.setMaximumSize(new Dimension(300, 30));
        return jValueSlider;
    }

    public static JFrame showForcePanel(ForceSimulator forceSimulator) {
        JFrame jFrame = new JFrame("prefuse Force Simulator");
        jFrame.setContentPane(new JForcePanel(forceSimulator));
        jFrame.pack();
        jFrame.setVisible(true);
        return jFrame;
    }

    private static class ForcePanelChangeListener
    implements ChangeListener {
        private ForcePanelChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JValueSlider jValueSlider = (JValueSlider)changeEvent.getSource();
            float f = jValueSlider.getValue().floatValue();
            Force force = (Force)jValueSlider.getClientProperty("force");
            Integer n = (Integer)jValueSlider.getClientProperty("param");
            force.setParameter(n, f);
        }
    }
}

