/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.Map;
import prefuse.action.assignment.ShapeAction;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.visual.VisualItem;

public class DataShapeAction
extends ShapeAction {
    protected static final int NO_SHAPE = Integer.MIN_VALUE;
    protected String m_dataField;
    protected int[] m_palette;
    protected Map m_ordinalMap;

    public DataShapeAction(String string, String string2) {
        super(string, Integer.MIN_VALUE);
        this.m_dataField = string2;
    }

    public DataShapeAction(String string, String string2, int[] nArray) {
        super(string, Integer.MIN_VALUE);
        this.m_dataField = string2;
        this.m_palette = nArray;
    }

    public String getDataField() {
        return this.m_dataField;
    }

    public void setDataField(String string) {
        this.m_dataField = string;
    }

    public void setDefaultShape(int n) {
        throw new UnsupportedOperationException();
    }

    protected void setup() {
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        this.m_ordinalMap = DataLib.ordinalMap(tupleSet, this.m_dataField);
    }

    public int getShape(VisualItem visualItem) {
        int n = super.getShape(visualItem);
        if (n != Integer.MIN_VALUE) {
            return n;
        }
        Object object = visualItem.get(this.m_dataField);
        int n2 = (Integer)this.m_ordinalMap.get(object);
        if (this.m_palette == null) {
            return n2 % 10;
        }
        return this.m_palette[n2 % this.m_palette.length];
    }
}

