/*==============================================================================

  Program: 3D Slicer

  Copyright (c) 2010 Kitware Inc.

  See Doc/copyright/copyright.txt
  or http://www.slicer.org/copyright/copyright.txt for details.

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  This file was originally developed by Julien Finet, Kitware Inc.
  and was partially funded by NIH grant 3P41RR013218-12S1

==============================================================================*/

#ifndef __qMRMLColorPickerWidget_h
#define __qMRMLColorPickerWidget_h

// qMRML includes
#include "qMRMLWidget.h"
#include "qMRMLWidgetsExport.h"

class qMRMLColorPickerWidgetPrivate;

class QMRML_WIDGETS_EXPORT qMRMLColorPickerWidget : public qMRMLWidget
{
  Q_OBJECT
public:
  qMRMLColorPickerWidget(QWidget *parent=0);
  virtual ~qMRMLColorPickerWidget();

signals:
  void colorSelected(int index);
  void colorSelected(const QColor& color);

protected:
  QScopedPointer<qMRMLColorPickerWidgetPrivate> d_ptr;

private:
  Q_DECLARE_PRIVATE(qMRMLColorPickerWidget);
  Q_DISABLE_COPY(qMRMLColorPickerWidget);
};

#endif
