/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import prefuse.data.Tuple;

public class SortedTupleIterator
implements Iterator {
    private ArrayList m_tuples;
    private Comparator m_cmp;
    private Iterator m_iter;

    public SortedTupleIterator(Iterator iterator, Comparator comparator) {
        this(iterator, 128, comparator);
    }

    public SortedTupleIterator(Iterator iterator, int n, Comparator comparator) {
        this.m_tuples = new ArrayList(n);
        this.init(iterator, comparator);
    }

    public void init(Iterator iterator, Comparator comparator) {
        this.m_tuples.clear();
        this.m_cmp = comparator;
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            this.m_tuples.add(tuple);
        }
        Collections.sort(this.m_tuples, this.m_cmp);
        this.m_iter = this.m_tuples.iterator();
    }

    public boolean hasNext() {
        return this.m_iter.hasNext();
    }

    public Object next() {
        return this.m_iter.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

