/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Arrays;
import java.util.Comparator;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.TupleComparator;
import prefuse.util.collections.CompositeComparator;
import prefuse.util.collections.NullComparator;

public class Sort {
    private static final String ASC = " ASC";
    private static final String DESC = " DESC";
    private static final String asc = " ASC".toLowerCase();
    private static final String desc = " DESC".toLowerCase();
    private String[] m_fields;
    private boolean[] m_ascend;

    public Sort() {
        this(new String[0], new boolean[0]);
    }

    public Sort(String[] stringArray) {
        this(stringArray, new boolean[stringArray.length]);
        Arrays.fill(this.m_ascend, true);
    }

    public Sort(String[] stringArray, boolean[] blArray) {
        this.m_fields = stringArray;
        this.m_ascend = blArray;
    }

    public void add(String string, boolean bl) {
        String[] stringArray = new String[this.m_fields.length + 1];
        System.arraycopy(this.m_fields, 0, stringArray, 0, this.m_fields.length);
        stringArray[this.m_fields.length] = string;
        this.m_fields = stringArray;
        boolean[] blArray = new boolean[this.m_fields.length + 1];
        System.arraycopy(this.m_ascend, 0, blArray, 0, this.m_ascend.length);
        blArray[this.m_ascend.length] = bl;
        this.m_ascend = blArray;
    }

    public int size() {
        return this.m_fields.length;
    }

    public String getField(int n) {
        return this.m_fields[n];
    }

    public boolean isAscending(int n) {
        return this.m_ascend[n];
    }

    public Comparator getComparator(TupleSet tupleSet) {
        Schema schema = null;
        if (tupleSet instanceof Table) {
            schema = ((Table)tupleSet).getSchema();
        } else {
            if (tupleSet.getTupleCount() == 0) {
                return new NullComparator();
            }
            schema = ((Tuple)tupleSet.tuples().next()).getSchema();
        }
        CompositeComparator compositeComparator = new CompositeComparator(this.m_fields.length);
        for (int i = 0; i < this.m_fields.length; ++i) {
            compositeComparator.add(new TupleComparator(this.m_fields[i], schema.getColumnType(this.m_fields[i]), this.m_ascend[i]));
        }
        return compositeComparator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void subparse(String string, Object[] objectArray) {
        string = string.trim();
        objectArray[1] = Boolean.TRUE;
        if (string.endsWith(DESC) || string.endsWith(desc)) {
            objectArray[1] = Boolean.FALSE;
            string = string.substring(0, string.length() - DESC.length()).trim();
        } else if (string.endsWith(ASC) || string.endsWith(asc)) {
            string = string.substring(0, string.length() - ASC.length()).trim();
        }
        if (string.startsWith("[")) {
            if (string.lastIndexOf("[") != 0 || !string.endsWith("]") || string.indexOf("]") != string.length()) throw new RuntimeException();
            objectArray[0] = string.substring(1, string.length() - 1);
            return;
        } else {
            if (string.indexOf(" ") >= 0 || string.indexOf("\t") >= 0) throw new RuntimeException();
            objectArray[0] = string;
        }
    }

    public static Sort parse(String string) {
        Sort sort = new Sort();
        Object[] objectArray = new Object[2];
        int n = 0;
        int n2 = string.length();
        int n3 = string.indexOf(44);
        int n4 = string.indexOf(91);
        while (n < n2) {
            if (n3 < 0) {
                Sort.subparse(string.substring(n), objectArray);
                sort.add((String)objectArray[0], (Boolean)objectArray[1]);
                break;
            }
            if (n4 < 0 || n3 < n4) {
                Sort.subparse(string.substring(n, n3), objectArray);
                sort.add((String)objectArray[0], (Boolean)objectArray[1]);
                n = n3 + 1;
                n3 = string.indexOf(n, 44);
                continue;
            }
            int n5 = string.indexOf(n4, 93);
            if (n5 < 0) {
                throw new RuntimeException();
            }
            n3 = string.indexOf(n5, 44);
            Sort.subparse(string.substring(n, n3), objectArray);
            sort.add((String)objectArray[0], (Boolean)objectArray[1]);
            n = n3 + 1;
            n3 = string.indexOf(n, 44);
        }
        return sort;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_fields.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[').append(this.m_fields[i]).append(']');
            stringBuffer.append(this.m_ascend[i] ? ASC : DESC);
        }
        return stringBuffer.toString();
    }
}

