/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.tuple;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import prefuse.Visualization;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.tuple.TableTuple;
import prefuse.data.tuple.TupleSet;
import prefuse.render.Renderer;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;

public class TableVisualItem
extends TableTuple
implements VisualItem {
    protected void init(Table table, Graph graph, int n) {
        this.m_table = table;
        this.m_row = this.m_table.isValidRow(n) ? n : -1;
    }

    public Visualization getVisualization() {
        return ((VisualTable)this.m_table).getVisualization();
    }

    public String getGroup() {
        return ((VisualTable)this.m_table).getGroup();
    }

    public boolean isInGroup(String string) {
        return this.getVisualization().isInGroup(this, string);
    }

    public TupleSet getSourceData() {
        VisualTable visualTable = (VisualTable)this.m_table;
        return visualTable.getVisualization().getSourceData(visualTable.getGroup());
    }

    public Tuple getSourceTuple() {
        VisualTable visualTable = (VisualTable)this.m_table;
        return visualTable.getVisualization().getSourceTuple(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VisualItem[").append(this.getGroup());
        stringBuffer.append(",").append(this.m_row).append(',');
        VisualTable visualTable = (VisualTable)this.m_table;
        int n = visualTable.getLocalColumnCount();
        int n2 = visualTable.getColumnCount() - n;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            String string = visualTable.getColumnName(n + i);
            stringBuffer.append(string);
            stringBuffer.append('=');
            if (visualTable.canGetString(string)) {
                stringBuffer.append(visualTable.getString(this.m_row, string));
                continue;
            }
            stringBuffer.append(visualTable.get(this.m_row, string).toString());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void render(Graphics2D graphics2D) {
        this.getRenderer().render(graphics2D, this);
    }

    public Renderer getRenderer() {
        return this.getVisualization().getRenderer(this);
    }

    public Rectangle2D validateBounds() {
        if (this.isValidated()) {
            return this.getBounds();
        }
        Visualization visualization = this.getVisualization();
        this.getRenderer().setBounds(this);
        this.setValidated(true);
        Rectangle2D rectangle2D = this.getBounds();
        visualization.damageReport(this, rectangle2D);
        return rectangle2D;
    }

    public boolean isValidated() {
        return ((VisualTable)this.m_table).isValidated(this.m_row);
    }

    public void setValidated(boolean bl) {
        ((VisualTable)this.m_table).setValidated(this.m_row, bl);
    }

    public boolean isVisible() {
        return ((VisualTable)this.m_table).isVisible(this.m_row);
    }

    public void setVisible(boolean bl) {
        ((VisualTable)this.m_table).setVisible(this.m_row, bl);
    }

    public boolean isStartVisible() {
        return ((VisualTable)this.m_table).isStartVisible(this.m_row);
    }

    public void setStartVisible(boolean bl) {
        ((VisualTable)this.m_table).setStartVisible(this.m_row, bl);
    }

    public boolean isEndVisible() {
        return ((VisualTable)this.m_table).isEndVisible(this.m_row);
    }

    public void setEndVisible(boolean bl) {
        ((VisualTable)this.m_table).setEndVisible(this.m_row, bl);
    }

    public boolean isInteractive() {
        return ((VisualTable)this.m_table).isInteractive(this.m_row);
    }

    public void setInteractive(boolean bl) {
        ((VisualTable)this.m_table).setInteractive(this.m_row, bl);
    }

    public boolean isExpanded() {
        return ((VisualTable)this.m_table).isExpanded(this.m_row);
    }

    public void setExpanded(boolean bl) {
        ((VisualTable)this.m_table).setExpanded(this.m_row, bl);
    }

    public boolean isFixed() {
        return ((VisualTable)this.m_table).isFixed(this.m_row);
    }

    public void setFixed(boolean bl) {
        ((VisualTable)this.m_table).setFixed(this.m_row, bl);
    }

    public boolean isHighlighted() {
        return ((VisualTable)this.m_table).isHighlighted(this.m_row);
    }

    public void setHighlighted(boolean bl) {
        ((VisualTable)this.m_table).setHighlighted(this.m_row, bl);
    }

    public boolean isHover() {
        return ((VisualTable)this.m_table).isHover(this.m_row);
    }

    public void setHover(boolean bl) {
        ((VisualTable)this.m_table).setHover(this.m_row, bl);
    }

    public double getX() {
        return ((VisualTable)this.m_table).getX(this.m_row);
    }

    public void setX(double d) {
        ((VisualTable)this.m_table).setX(this.m_row, d);
    }

    public double getY() {
        return ((VisualTable)this.m_table).getY(this.m_row);
    }

    public void setY(double d) {
        ((VisualTable)this.m_table).setY(this.m_row, d);
    }

    public double getStartX() {
        return ((VisualTable)this.m_table).getStartX(this.m_row);
    }

    public void setStartX(double d) {
        ((VisualTable)this.m_table).setStartX(this.m_row, d);
    }

    public double getStartY() {
        return ((VisualTable)this.m_table).getStartY(this.m_row);
    }

    public void setStartY(double d) {
        ((VisualTable)this.m_table).setStartY(this.m_row, d);
    }

    public double getEndX() {
        return ((VisualTable)this.m_table).getEndX(this.m_row);
    }

    public void setEndX(double d) {
        ((VisualTable)this.m_table).setEndX(this.m_row, d);
    }

    public double getEndY() {
        return ((VisualTable)this.m_table).getEndY(this.m_row);
    }

    public void setEndY(double d) {
        ((VisualTable)this.m_table).setEndY(this.m_row, d);
    }

    public Rectangle2D getBounds() {
        if (!this.isValidated()) {
            return this.validateBounds();
        }
        return ((VisualTable)this.m_table).getBounds(this.m_row);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        ((VisualTable)this.m_table).setBounds(this.m_row, d, d2, d3, d4);
    }

    public int getStrokeColor() {
        return ((VisualTable)this.m_table).getStrokeColor(this.m_row);
    }

    public void setStrokeColor(int n) {
        ((VisualTable)this.m_table).setStrokeColor(this.m_row, n);
    }

    public int getStartStrokeColor() {
        return ((VisualTable)this.m_table).getStartStrokeColor(this.m_row);
    }

    public void setStartStrokeColor(int n) {
        ((VisualTable)this.m_table).setStartStrokeColor(this.m_row, n);
    }

    public int getEndStrokeColor() {
        return ((VisualTable)this.m_table).getEndStrokeColor(this.m_row);
    }

    public void setEndStrokeColor(int n) {
        ((VisualTable)this.m_table).setEndStrokeColor(this.m_row, n);
    }

    public int getFillColor() {
        return ((VisualTable)this.m_table).getFillColor(this.m_row);
    }

    public void setFillColor(int n) {
        ((VisualTable)this.m_table).setFillColor(this.m_row, n);
    }

    public int getStartFillColor() {
        return ((VisualTable)this.m_table).getStartFillColor(this.m_row);
    }

    public void setStartFillColor(int n) {
        ((VisualTable)this.m_table).setStartFillColor(this.m_row, n);
    }

    public int getEndFillColor() {
        return ((VisualTable)this.m_table).getEndFillColor(this.m_row);
    }

    public void setEndFillColor(int n) {
        ((VisualTable)this.m_table).setEndFillColor(this.m_row, n);
    }

    public int getTextColor() {
        return ((VisualTable)this.m_table).getTextColor(this.m_row);
    }

    public void setTextColor(int n) {
        ((VisualTable)this.m_table).setTextColor(this.m_row, n);
    }

    public int getStartTextColor() {
        return ((VisualTable)this.m_table).getStartTextColor(this.m_row);
    }

    public void setStartTextColor(int n) {
        ((VisualTable)this.m_table).setStartTextColor(this.m_row, n);
    }

    public int getEndTextColor() {
        return ((VisualTable)this.m_table).getEndTextColor(this.m_row);
    }

    public void setEndTextColor(int n) {
        ((VisualTable)this.m_table).setEndTextColor(this.m_row, n);
    }

    public double getSize() {
        return ((VisualTable)this.m_table).getSize(this.m_row);
    }

    public void setSize(double d) {
        ((VisualTable)this.m_table).setSize(this.m_row, d);
    }

    public double getStartSize() {
        return ((VisualTable)this.m_table).getStartSize(this.m_row);
    }

    public void setStartSize(double d) {
        ((VisualTable)this.m_table).setStartSize(this.m_row, d);
    }

    public double getEndSize() {
        return ((VisualTable)this.m_table).getEndSize(this.m_row);
    }

    public void setEndSize(double d) {
        ((VisualTable)this.m_table).setEndSize(this.m_row, d);
    }

    public int getShape() {
        return ((VisualTable)this.m_table).getShape(this.m_row);
    }

    public void setShape(int n) {
        ((VisualTable)this.m_table).setShape(this.m_row, n);
    }

    public BasicStroke getStroke() {
        return ((VisualTable)this.m_table).getStroke(this.m_row);
    }

    public void setStroke(BasicStroke basicStroke) {
        ((VisualTable)this.m_table).setStroke(this.m_row, basicStroke);
    }

    public Font getFont() {
        return ((VisualTable)this.m_table).getFont(this.m_row);
    }

    public void setFont(Font font) {
        ((VisualTable)this.m_table).setFont(this.m_row, font);
    }

    public Font getStartFont() {
        return ((VisualTable)this.m_table).getStartFont(this.m_row);
    }

    public void setStartFont(Font font) {
        ((VisualTable)this.m_table).setStartFont(this.m_row, font);
    }

    public Font getEndFont() {
        return ((VisualTable)this.m_table).getEndFont(this.m_row);
    }

    public void setEndFont(Font font) {
        ((VisualTable)this.m_table).setEndFont(this.m_row, font);
    }

    public double getDOI() {
        return ((VisualTable)this.m_table).getDOI(this.m_row);
    }

    public void setDOI(double d) {
        ((VisualTable)this.m_table).setDOI(this.m_row, d);
    }
}

