/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.util.Arrays;

public class MathLib {
    public static final double TWO_PI = Math.PI * 2;
    public static final double LOG10 = Math.log(10.0);
    public static final double LOG2 = Math.log(2.0);

    private MathLib() {
    }

    public static double log2(double d) {
        return Math.log(d) / LOG2;
    }

    public static double log10(double d) {
        return Math.log(d) / LOG10;
    }

    public static double safeLog10(double d) {
        boolean bl;
        boolean bl2 = bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (d < 10.0) {
            d += (10.0 - d) / 10.0;
        }
        d = Math.log(d) / LOG10;
        return bl ? -d : d;
    }

    public static double safeSqrt(double d) {
        return d < 0.0 ? -Math.sqrt(-d) : Math.sqrt(d);
    }

    public static double interp(int n, double d, double[] dArray) {
        switch (n) {
            case 0: {
                return MathLib.linearInterp(d, dArray[0], dArray[dArray.length - 1]);
            }
            case 1: {
                return MathLib.logInterp(d, dArray[0], dArray[dArray.length - 1]);
            }
            case 2: {
                return MathLib.sqrtInterp(d, dArray[0], dArray[dArray.length - 1]);
            }
            case 3: {
                return MathLib.quantile(d, dArray);
            }
        }
        throw new IllegalArgumentException("Unrecognized scale value: " + n);
    }

    public static double linearInterp(double d, double d2, double d3) {
        double d4 = d3 - d2;
        if (d4 == 0.0) {
            return 0.0;
        }
        return (d - d2) / d4;
    }

    public static double logInterp(double d, double d2, double d3) {
        double d4 = MathLib.safeLog10(d2);
        double d5 = MathLib.safeLog10(d3) - d4;
        if (d5 == 0.0) {
            return 0.0;
        }
        return (MathLib.safeLog10(d) - d4) / d5;
    }

    public static double sqrtInterp(double d, double d2, double d3) {
        double d4 = MathLib.safeSqrt(d2);
        double d5 = MathLib.safeSqrt(d3) - d4;
        if (d5 == 0.0) {
            return 0.0;
        }
        return (MathLib.safeSqrt(d) - d4) / d5;
    }

    public static double[] quantiles(int n, double[] dArray) {
        dArray = (double[])dArray.clone();
        Arrays.sort(dArray);
        double[] dArray2 = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            dArray2[i] = dArray[(dArray.length - 1) * i / n];
        }
        return dArray2;
    }

    public static double quantile(double d, double[] dArray) {
        int n = 1;
        int n2 = dArray.length;
        int n3 = n2 / 2;
        while (n < n2 && dArray[n3] != d) {
            if (dArray[n3] < d) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + (n2 - n) / 2;
        }
        return (double)n3 / (double)(dArray.length - 1);
    }
}

