/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.geom.Point2D;
import prefuse.Display;
import prefuse.controls.ControlAdapter;

public class AbstractZoomControl
extends ControlAdapter {
    public static final double DEFAULT_MIN_SCALE = 0.001;
    public static final double DEFAULT_MAX_SCALE = 75.0;
    protected static final int ZOOM = 0;
    protected static final int MIN_ZOOM = 1;
    protected static final int MAX_ZOOM = 2;
    protected static final int NO_ZOOM = 3;
    protected double m_minScale = 0.001;
    protected double m_maxScale = 75.0;
    protected boolean m_zoomOverItem = true;

    protected int zoom(Display display, Point2D point2D, double d, boolean bl) {
        if (display.isTranformInProgress()) {
            return 3;
        }
        double d2 = display.getScale();
        double d3 = d2 * d;
        int n = 0;
        if (d3 < this.m_minScale) {
            d = this.m_minScale / d2;
            n = 1;
        } else if (d3 > this.m_maxScale) {
            d = this.m_maxScale / d2;
            n = 2;
        }
        if (bl) {
            display.zoomAbs(point2D, d);
        } else {
            display.zoom(point2D, d);
        }
        display.repaint();
        return n;
    }

    public double getMaxScale() {
        return this.m_maxScale;
    }

    public void setMaxScale(double d) {
        this.m_maxScale = d;
    }

    public double getMinScale() {
        return this.m_minScale;
    }

    public void setMinScale(double d) {
        this.m_minScale = d;
    }

    public boolean isZoomOverItem() {
        return this.m_zoomOverItem;
    }

    public void setZoomOverItem(boolean bl) {
        this.m_zoomOverItem = bl;
    }
}

