/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.Display;
import prefuse.visual.VisualItem;

public class DisplayLib {
    private DisplayLib() {
    }

    public static Rectangle2D getBounds(Iterator iterator, double d, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2;
        VisualItem visualItem;
        rectangle2D.setFrame(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        if (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            rectangle2D2 = visualItem.getBounds();
            rectangle2D.setFrame(rectangle2D2);
        }
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            rectangle2D2 = visualItem.getBounds();
            double d2 = rectangle2D2.getMinX() < rectangle2D.getMinX() ? rectangle2D2.getMinX() : rectangle2D.getMinX();
            double d3 = rectangle2D2.getMaxX() > rectangle2D.getMaxX() ? rectangle2D2.getMaxX() : rectangle2D.getMaxX();
            double d4 = rectangle2D2.getMinY() < rectangle2D.getMinY() ? rectangle2D2.getMinY() : rectangle2D.getMinY();
            double d5 = rectangle2D2.getMaxY() > rectangle2D.getMaxY() ? rectangle2D2.getMaxY() : rectangle2D.getMaxY();
            rectangle2D.setFrame(d2, d4, d3 - d2, d5 - d4);
        }
        rectangle2D.setFrame(rectangle2D.getMinX() - d, rectangle2D.getMinY() - d, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d);
        return rectangle2D;
    }

    public static Rectangle2D getBounds(Iterator iterator, double d) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        return DisplayLib.getBounds(iterator, d, double_);
    }

    public static Point2D getCentroid(Iterator iterator, Point2D point2D) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            double d3 = visualItem.getX();
            double d4 = visualItem.getY();
            if (Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4)) continue;
            d += d3;
            d2 += d4;
            ++n;
        }
        if (n > 0) {
            d /= (double)n;
            d2 /= (double)n;
        }
        point2D.setLocation(d, d2);
        return point2D;
    }

    public static Point2D getCentroid(Iterator iterator) {
        return DisplayLib.getCentroid(iterator, new Point2D.Double());
    }

    public static void fitViewToBounds(Display display, Rectangle2D rectangle2D, long l) {
        DisplayLib.fitViewToBounds(display, rectangle2D, null, l);
    }

    public static void fitViewToBounds(Display display, Rectangle2D rectangle2D, Point2D point2D, long l) {
        double d = display.getWidth();
        double d2 = display.getHeight();
        double d3 = point2D == null ? rectangle2D.getCenterX() : point2D.getX();
        double d4 = point2D == null ? rectangle2D.getCenterY() : point2D.getY();
        double d5 = Math.max(d3 - rectangle2D.getMinX(), rectangle2D.getMaxX() - d3);
        double d6 = Math.max(d4 - rectangle2D.getMinY(), rectangle2D.getMaxY() - d4);
        double d7 = Math.min(d / (2.0 * d5), d2 / (2.0 * d6)) / display.getScale();
        if (point2D == null) {
            point2D = new Point2D.Double(d3, d4);
        }
        if (l > 0L) {
            display.animatePanAndZoomToAbs(point2D, d7, l);
        } else {
            display.panToAbs(point2D);
            display.zoomAbs(point2D, d7);
        }
    }
}

