/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.BitSet;
import java.util.Comparator;
import java.util.NoSuchElementException;
import prefuse.util.collections.BooleanIntSortedMap;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.LiteralIterator;

public class BooleanIntBitSetMap
implements BooleanIntSortedMap {
    private BitSet m_true = new BitSet();
    private BitSet m_false = new BitSet();

    public boolean firstKey() {
        return false;
    }

    public boolean lastKey() {
        return true;
    }

    public boolean containsKey(boolean bl) {
        BitSet bitSet = bl ? this.m_true : this.m_false;
        return bitSet.cardinality() > 0;
    }

    public IntIterator valueRangeIterator(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl2 && !bl4) {
            return new BitSetIterator(null);
        }
        if (bl == bl3 || !bl4) {
            return new BitSetIterator(bl ? this.m_true : this.m_false);
        }
        if (!bl2) {
            return new BitSetIterator(bl3 ? this.m_true : this.m_false);
        }
        return new BitSetIterator(bl ? this.m_true : this.m_false, bl3 ? this.m_true : this.m_false);
    }

    public LiteralIterator keyIterator() {
        return new BitSetIterator(this.m_false, this.m_true);
    }

    public LiteralIterator keyRangeIterator(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl2 && !bl4) {
            return new BitSetIterator(null);
        }
        if (bl == bl3 || !bl4) {
            return new BitSetIterator(bl ? this.m_true : this.m_false);
        }
        if (!bl2) {
            return new BitSetIterator(bl3 ? this.m_true : this.m_false);
        }
        return new BitSetIterator(bl ? this.m_true : this.m_false, bl3 ? this.m_true : this.m_false);
    }

    public int get(boolean bl) {
        BitSet bitSet = bl ? this.m_true : this.m_false;
        return bitSet.nextSetBit(0);
    }

    public int remove(boolean bl) {
        BitSet bitSet = bl ? this.m_true : this.m_false;
        int n = bitSet.length() - 1;
        bitSet.clear(n);
        return n;
    }

    public int remove(boolean bl, int n) {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = bl ? this.m_true : this.m_false;
        if (bitSet.get(n)) {
            bitSet.clear(n);
            return n;
        }
        return Integer.MIN_VALUE;
    }

    public int put(boolean bl, int n) {
        BitSet bitSet = bl ? this.m_true : this.m_false;
        boolean bl2 = bitSet.get(n);
        bitSet.set(n);
        return bl2 ? n : Integer.MIN_VALUE;
    }

    public int getMinimum() {
        if (this.m_false.cardinality() > 0) {
            return this.m_false.nextSetBit(0);
        }
        if (this.m_true.cardinality() > 0) {
            return this.m_true.nextSetBit(0);
        }
        return Integer.MIN_VALUE;
    }

    public int getMaximum() {
        int n = this.m_true.length() - 1;
        return n > 0 ? n : this.m_false.length() - 1;
    }

    public int getMedian() {
        int n = this.m_false.cardinality();
        int n2 = this.m_true.cardinality();
        if (n == 0 && n2 == 0) {
            return Integer.MIN_VALUE;
        }
        int n3 = (n + n2) / 2;
        BitSet bitSet = n > n2 ? this.m_false : this.m_true;
        int n4 = bitSet.nextSetBit(0);
        int n5 = 0;
        while (n4 >= 0) {
            if (n5 == n3) {
                return n4;
            }
            n4 = bitSet.nextSetBit(n4 + 1);
            ++n5;
        }
        return Integer.MIN_VALUE;
    }

    public int getUniqueCount() {
        int n = 0;
        if (this.m_false.cardinality() > 0) {
            ++n;
        }
        if (this.m_true.cardinality() > 0) {
            ++n;
        }
        return n;
    }

    public boolean isAllowDuplicates() {
        return true;
    }

    public int size() {
        return this.m_true.cardinality() + this.m_false.cardinality();
    }

    public boolean isEmpty() {
        return this.m_true.isEmpty() && this.m_false.isEmpty();
    }

    public Comparator comparator() {
        return DefaultLiteralComparator.getInstance();
    }

    public void clear() {
        this.m_true.clear();
        this.m_false.clear();
    }

    public boolean containsValue(int n) {
        return this.m_false.get(n) || this.m_true.get(n);
    }

    public IntIterator valueIterator(boolean bl) {
        if (!bl) {
            return new BitSetIterator(this.m_true, this.m_false);
        }
        return new BitSetIterator(this.m_false, this.m_true);
    }

    public class BitSetIterator
    extends IntIterator {
        private BitSet m_cur;
        private BitSet m_next;
        private int m_val = -1;

        public BitSetIterator(BitSet bitSet) {
            this(bitSet, null);
        }

        public BitSetIterator(BitSet bitSet, BitSet bitSet2) {
            this.m_cur = bitSet;
            this.m_next = bitSet2;
            if (bitSet == null) {
                this.m_val = -2;
            } else {
                this.m_val = -1;
                this.advance();
            }
        }

        private void advance() {
            int n = this.m_cur.nextSetBit(this.m_val + 1);
            if (n < 0) {
                if (this.m_next != null) {
                    this.m_cur = this.m_next;
                    this.m_next = null;
                    this.m_val = -1;
                    this.advance();
                } else {
                    this.m_val = -2;
                }
                return;
            }
            this.m_val = n;
        }

        public int nextInt() {
            if (this.m_val < 0) {
                throw new NoSuchElementException();
            }
            int n = this.m_val;
            this.advance();
            return n;
        }

        public boolean nextBoolean() {
            if (this.m_cur == BooleanIntBitSetMap.this.m_true) {
                this.advance();
                return true;
            }
            if (this.m_cur == BooleanIntBitSetMap.this.m_false) {
                this.advance();
                return false;
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.m_val >= 0;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

