/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import prefuse.util.io.IOLib;

public class PrefuseConfig
extends Properties {
    private static final Logger s_logger = Logger.getLogger(PrefuseConfig.class.getName());
    private static final PrefuseConfig s_config = new PrefuseConfig();

    public static PrefuseConfig getConfig() {
        return s_config;
    }

    private PrefuseConfig() {
        String string;
        this.setDefaults();
        try {
            string = System.getProperty("prefuse.config");
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null) {
            string = "prefuse.conf";
        }
        try {
            this.load(IOLib.streamFromString(string));
            s_logger.info("Loaded config file: " + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = this.getProperty("util.logdir");
        String string3 = this.getProperty("util.logfile");
        if (string2 != null) {
            try {
                Logger logger = Logger.getLogger("prefuse");
                logger.setUseParentHandlers(false);
                FileHandler fileHandler = new FileHandler(string2 + "/" + string3);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String get(String string) {
        return s_config.getProperty(string);
    }

    public static int getInt(String string) {
        String string2 = s_config.getProperty(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MIN_VALUE;
        }
    }

    public static long getLong(String string) {
        String string2 = s_config.getProperty(string);
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return Long.MIN_VALUE;
        }
    }

    public static float getFloat(String string) {
        String string2 = s_config.getProperty(string);
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return Float.NaN;
        }
    }

    public static double getDouble(String string) {
        String string2 = s_config.getProperty(string);
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static boolean getBoolean(String string) {
        String string2 = s_config.getProperty(string);
        return "true".equalsIgnoreCase(string2);
    }

    private void setDefaults() {
        this.setProperty("size.scale2D", "0.5");
        this.setProperty("activity.threadPriority", "6");
        this.setProperty("data.delimiter", ".");
        this.setProperty("data.graph.nodeGroup", "nodes");
        this.setProperty("data.graph.edgeGroup", "edges");
        this.setProperty("data.visual.fieldPrefix", "_");
        this.setProperty("data.io.worker.threadPriority", String.valueOf(5));
        this.setProperty("data.filter.optimizeThreshold", "300");
        this.setProperty("data.graph.sourceKey", "source");
        this.setProperty("data.graph.targetKey", "target");
        this.setProperty("data.tree.sourceKey", "parent");
        this.setProperty("data.tree.targetKey", "child");
        this.setProperty("visualization.allItems", "_all_");
        this.setProperty("visualization.focusItems", "_focus_");
        this.setProperty("visualization.selectedItems", "_selected_");
        this.setProperty("visualization.searchItems", "_search_");
        this.setProperty("util.logfile", "prefuse_log_%g.txt");
    }
}

