/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Tuple;
import prefuse.data.event.ExpressionListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.util.collections.CopyOnWriteArrayList;

public abstract class AbstractExpression
implements Expression,
ExpressionListener {
    private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();

    public void visit(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visitExpression(this);
    }

    public final void addExpressionListener(ExpressionListener expressionListener) {
        if (!this.m_listeners.contains(expressionListener)) {
            this.m_listeners.add(expressionListener);
            this.addChildListeners();
        }
    }

    public final void removeExpressionListener(ExpressionListener expressionListener) {
        this.m_listeners.remove(expressionListener);
        if (this.m_listeners.size() == 0) {
            this.removeChildListeners();
        }
    }

    protected final boolean hasListeners() {
        return this.m_listeners != null && this.m_listeners.size() > 0;
    }

    protected final void fireExpressionChange() {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ExpressionListener)objectArray[i]).expressionChanged(this);
        }
    }

    protected void addChildListeners() {
    }

    protected void removeChildListeners() {
    }

    public void expressionChanged(Expression expression) {
        this.fireExpressionChange();
    }

    public Object get(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    public int getInt(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    public long getLong(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    public float getFloat(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(Tuple tuple) {
        throw new UnsupportedOperationException();
    }
}

