/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Date;
import prefuse.data.DataTypeException;
import prefuse.data.column.Column;
import prefuse.data.event.ColumnListener;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ObjectParser;
import prefuse.data.parser.ParserFactory;
import prefuse.util.TypeLib;
import prefuse.util.collections.CopyOnWriteArrayList;

public abstract class AbstractColumn
implements Column {
    protected final Class m_columnType;
    protected DataParser m_parser;
    protected Object m_defaultValue;
    protected boolean m_readOnly;
    protected CopyOnWriteArrayList m_listeners;

    public AbstractColumn() {
        this(Object.class, null);
    }

    public AbstractColumn(Class clazz) {
        this(clazz, null);
    }

    public AbstractColumn(Class clazz, Object object) {
        this.m_columnType = clazz;
        DataParser dataParser = ParserFactory.getDefaultFactory().getParser(clazz);
        this.m_parser = dataParser == null ? new ObjectParser() : dataParser;
        this.setDefaultValue(object);
        this.m_readOnly = false;
        this.m_listeners = new CopyOnWriteArrayList();
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.m_readOnly = bl;
    }

    public boolean isCellEditable(int n) {
        return !this.m_readOnly;
    }

    public Class getColumnType() {
        return this.m_columnType;
    }

    public DataParser getParser() {
        return this.m_parser;
    }

    public void setParser(DataParser dataParser) {
        if (!this.m_columnType.isAssignableFrom(dataParser.getType())) {
            throw new IllegalArgumentException("Parser type (" + dataParser.getType().getName() + ") incompatible with" + " this column's data type (" + this.m_columnType.getName() + ")");
        }
        this.m_parser = dataParser;
    }

    public void addColumnListener(ColumnListener columnListener) {
        this.m_listeners.add(columnListener);
    }

    public void removeColumnListener(ColumnListener columnListener) {
        this.m_listeners.remove(columnListener);
    }

    protected final void fireColumnEvent(int n, int n2, int n3) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ColumnListener)objectArray[i]).columnChanged(this, n, n2, n3);
        }
    }

    protected final void fireColumnEvent(int n, int n2) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ColumnListener)objectArray[i]).columnChanged((Column)this, n, n2);
        }
    }

    protected final void fireColumnEvent(int n, long l) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ColumnListener)objectArray[i]).columnChanged((Column)this, n, l);
        }
    }

    protected final void fireColumnEvent(int n, float f) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ColumnListener)objectArray[i]).columnChanged((Column)this, n, f);
        }
    }

    protected final void fireColumnEvent(int n, double d) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ColumnListener)objectArray[i]).columnChanged((Column)this, n, d);
        }
    }

    protected final void fireColumnEvent(int n, boolean bl) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ColumnListener)objectArray[i]).columnChanged((Column)this, n, bl);
        }
    }

    protected final void fireColumnEvent(int n, Object object) {
        Object[] objectArray = this.m_listeners.getArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ColumnListener)objectArray[i]).columnChanged((Column)this, n, object);
        }
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public void setDefaultValue(Object object) {
        boolean bl = this.m_columnType.isPrimitive();
        if (object != null && (!bl && !this.m_columnType.isInstance(object) || bl && !TypeLib.isWrapperInstance(this.m_columnType, object))) {
            throw new IllegalArgumentException("Default value is not of type " + this.m_columnType.getName());
        }
        this.m_defaultValue = object;
    }

    public void revertToDefault(int n) {
        this.set(this.m_defaultValue, n);
    }

    public boolean canGet(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.m_columnType.isPrimitive()) {
            boolean bl = clazz.isAssignableFrom(this.m_columnType) || TypeLib.isNumericType(this.m_columnType) && TypeLib.isNumericType(clazz);
            return bl || clazz.isAssignableFrom(TypeLib.getWrapperType(this.m_columnType)) || clazz.isAssignableFrom(String.class);
        }
        return clazz.isAssignableFrom(this.m_columnType);
    }

    public boolean canSet(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.m_columnType.isPrimitive()) {
            return this.m_columnType.isAssignableFrom(clazz) || TypeLib.getWrapperType(this.m_columnType).isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz);
        }
        return this.m_columnType.isAssignableFrom(clazz);
    }

    public boolean canGetInt() {
        return this.canGet(Integer.TYPE);
    }

    public boolean canSetInt() {
        return this.canSet(Integer.TYPE);
    }

    public int getInt(int n) throws DataTypeException {
        if (this.canGetInt()) {
            return (Integer)this.get(n);
        }
        throw new DataTypeException(Integer.TYPE);
    }

    public void setInt(int n, int n2) throws DataTypeException {
        if (!this.canSetInt()) {
            throw new DataTypeException(Integer.TYPE);
        }
        this.set(new Integer(n), n2);
    }

    public boolean canGetLong() {
        return this.canGet(Long.TYPE);
    }

    public boolean canSetLong() {
        return this.canSet(Long.TYPE);
    }

    public long getLong(int n) throws DataTypeException {
        if (this.canGetLong()) {
            return (Long)this.get(n);
        }
        throw new DataTypeException(Long.TYPE);
    }

    public void setLong(long l, int n) throws DataTypeException {
        if (!this.canSetLong()) {
            throw new DataTypeException(Long.TYPE);
        }
        this.set(new Long(l), n);
    }

    public boolean canGetFloat() {
        return this.canGet(Float.TYPE);
    }

    public boolean canSetFloat() {
        return this.canSet(Float.TYPE);
    }

    public float getFloat(int n) throws DataTypeException {
        if (this.canGetFloat()) {
            return ((Float)this.get(n)).floatValue();
        }
        throw new DataTypeException(Float.TYPE);
    }

    public void setFloat(float f, int n) throws DataTypeException {
        if (!this.canSetFloat()) {
            throw new DataTypeException(Float.TYPE);
        }
        this.set(new Float(f), n);
    }

    public boolean canGetDouble() {
        return this.canGet(Double.TYPE);
    }

    public boolean canSetDouble() {
        return this.canSet(Double.TYPE);
    }

    public double getDouble(int n) throws DataTypeException {
        if (this.canGetDouble()) {
            return (Double)this.get(n);
        }
        throw new DataTypeException(Double.TYPE);
    }

    public void setDouble(double d, int n) throws DataTypeException {
        if (!this.canSetDouble()) {
            throw new DataTypeException(Double.TYPE);
        }
        this.set(new Double(d), n);
    }

    public boolean canGetBoolean() {
        return this.canGet(Boolean.TYPE);
    }

    public boolean canSetBoolean() {
        return this.canSet(Boolean.TYPE);
    }

    public boolean getBoolean(int n) throws DataTypeException {
        if (this.canGetBoolean()) {
            return (Boolean)this.get(n);
        }
        throw new DataTypeException(Boolean.TYPE);
    }

    public void setBoolean(boolean bl, int n) throws DataTypeException {
        if (!this.canSetBoolean()) {
            throw new DataTypeException(Boolean.TYPE);
        }
        this.set(new Boolean(bl), n);
    }

    public boolean canGetString() {
        return true;
    }

    public boolean canSetString() {
        return this.m_parser != null && !(this.m_parser instanceof ObjectParser);
    }

    public String getString(int n) throws DataTypeException {
        if (this.canGetString()) {
            return this.m_parser.format(this.get(n));
        }
        throw new DataTypeException(String.class);
    }

    public void setString(String string, int n) throws DataTypeException {
        try {
            this.set(this.m_parser.parse(string), n);
        }
        catch (DataParseException dataParseException) {
            throw new DataTypeException(dataParseException);
        }
    }

    public boolean canGetDate() {
        return this.canGet(Date.class);
    }

    public boolean canSetDate() {
        return this.canSet(Date.class);
    }

    public Date getDate(int n) throws DataTypeException {
        if (this.canGetDate()) {
            return (Date)this.get(n);
        }
        throw new DataTypeException(Date.class);
    }

    public void setDate(Date date, int n) throws DataTypeException {
        this.set(date, n);
    }
}

