/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import prefuse.util.collections.AbstractTreeMap;
import prefuse.util.collections.FloatIntSortedMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.LiteralComparator;
import prefuse.util.collections.LiteralIterator;

public class FloatIntTreeMap
extends AbstractTreeMap
implements FloatIntSortedMap {
    private FloatEntry dummy = new FloatEntry(Float.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public FloatIntTreeMap() {
        this(null, false);
    }

    public FloatIntTreeMap(boolean bl) {
        this(null, bl);
    }

    public FloatIntTreeMap(LiteralComparator literalComparator) {
        this(literalComparator, false);
    }

    public FloatIntTreeMap(LiteralComparator literalComparator, boolean bl) {
        super(literalComparator, bl);
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    public boolean containsKey(float f) {
        return this.find(f, 0) != NIL;
    }

    public int get(float f) {
        AbstractTreeMap.Entry entry = this.find(f, 0);
        return entry == NIL ? Integer.MIN_VALUE : entry.val;
    }

    public int put(float f, int n) {
        AbstractTreeMap.Entry entry = this.root;
        this.lastOrder = 0;
        if (entry == NIL) {
            this.incrementSize(true);
            this.root = new FloatEntry(f, n, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = f;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int n2;
            if ((n2 = this.compare(this.dummy, entry)) == 0) {
                return entry.setValue(n);
            }
            if (n2 < 0) {
                if (entry.left != NIL) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                entry.left = new FloatEntry(f, n, entry, this.lastOrder);
                this.fixUpInsert(entry.left);
                return Integer.MIN_VALUE;
            }
            if (entry.right == NIL) break;
            entry = entry.right;
        }
        this.incrementSize(this.lastOrder == 0);
        entry.right = new FloatEntry(f, n, entry, this.lastOrder);
        this.fixUpInsert(entry.right);
        return Integer.MIN_VALUE;
    }

    public int remove(float f) {
        AbstractTreeMap.Entry entry = this.allowDuplicates ? this.findPredecessor(f, Integer.MAX_VALUE) : this.find(f, 0);
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        int n = entry.val;
        this.remove(entry);
        return n;
    }

    public int remove(float f, int n) {
        AbstractTreeMap.Entry entry = this.findCeiling(f, 0);
        if (entry != NIL && entry.getFloatKey() != f) {
            entry = this.successor(entry);
        }
        if (entry == NIL || entry.getFloatKey() != f) {
            return Integer.MIN_VALUE;
        }
        while (entry.val != n && entry != NIL) {
            entry = this.successor(entry);
        }
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        this.remove(entry);
        return n;
    }

    public float firstKey() {
        return this.minimum(this.root).getFloatKey();
    }

    public float lastKey() {
        return this.maximum(this.root).getFloatKey();
    }

    public LiteralIterator keyIterator() {
        return new KeyIterator();
    }

    public LiteralIterator keyRangeIterator(float f, boolean bl, float f2, boolean bl2) {
        AbstractTreeMap.Entry entry;
        AbstractTreeMap.Entry entry2;
        if (this.cmp.compare(f, f2) <= 0) {
            entry2 = this.findCeiling(f, bl ? 0 : Integer.MAX_VALUE);
            entry = this.findCeiling(f2, bl2 ? Integer.MAX_VALUE : 0);
        } else {
            entry2 = this.findCeiling(f, bl ? Integer.MAX_VALUE : 0);
            entry2 = this.predecessor(entry2);
            entry = this.findCeiling(f2, bl2 ? 0 : Integer.MAX_VALUE);
            entry = this.predecessor(entry);
        }
        return new KeyIterator(entry2, entry);
    }

    public IntIterator valueRangeIterator(float f, boolean bl, float f2, boolean bl2) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(f, bl, f2, bl2));
    }

    protected int compare(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
        int n = this.cmp.compare(entry.getFloatKey(), entry2.getFloatKey());
        if (this.allowDuplicates && n == 0) {
            n = entry.order < entry2.order ? -1 : (entry.order > entry2.order ? 1 : 0);
            this.lastOrder = 1 + (n < 0 ? entry.order : entry2.order);
        }
        return n;
    }

    private AbstractTreeMap.Entry find(float f, int n) {
        this.dummy.key = f;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.find(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findPredecessor(float f, int n) {
        this.dummy.key = f;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.findPredecessor(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findCeiling(float f, int n) {
        this.dummy.key = f;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.findCeiling(this.dummy);
        return entry;
    }

    private class KeyIterator
    extends AbstractTreeMap.KeyIterator {
        public KeyIterator() {
        }

        public KeyIterator(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
            super(entry, entry2);
        }

        public boolean isFloatSupported() {
            return true;
        }

        public float nextFloat() {
            return this.nextEntry().getFloatKey();
        }
    }

    static class FloatEntry
    extends AbstractTreeMap.Entry {
        float key;

        public FloatEntry(float f, int n) {
            super(n);
            this.key = f;
        }

        public FloatEntry(float f, int n, AbstractTreeMap.Entry entry, int n2) {
            super(n, entry, n2);
            this.key = f;
        }

        public float getFloatKey() {
            return this.key;
        }

        public Object getKey() {
            return new Float(this.key);
        }

        public boolean keyEquals(AbstractTreeMap.Entry entry) {
            return entry instanceof FloatEntry && this.key == ((FloatEntry)entry).key;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FloatEntry)) {
                return false;
            }
            FloatEntry floatEntry = (FloatEntry)object;
            return this.key == floatEntry.key && this.val == floatEntry.val;
        }

        public int hashCode() {
            int n = Float.floatToIntBits(this.key);
            int n2 = this.val;
            return n ^ n2 ^ this.order;
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        public void copyFields(AbstractTreeMap.Entry entry) {
            super.copyFields(entry);
            this.key = entry.getFloatKey();
        }
    }
}

