/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Comparator;
import prefuse.data.Tuple;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.LiteralComparator;

public class TupleComparator
implements Comparator {
    private String m_field;
    private int m_col;
    private Comparator m_cmp;
    private Class m_type;
    private int m_rev;

    public TupleComparator(String string, Class clazz, boolean bl) {
        this(string, clazz, bl, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public TupleComparator(String string, Class clazz, boolean bl, Comparator comparator) {
        this.m_field = string;
        this.m_col = -1;
        this.m_type = clazz;
        this.m_rev = bl ? 1 : -1;
        this.m_cmp = comparator;
    }

    public TupleComparator(int n, Class clazz, boolean bl) {
        this(n, clazz, bl, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public TupleComparator(int n, Class clazz, boolean bl, Comparator comparator) {
        this.m_field = null;
        this.m_col = n;
        this.m_type = clazz;
        this.m_rev = bl ? 1 : -1;
        this.m_cmp = comparator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compare(Object object, Object object2) {
        Tuple tuple = (Tuple)object;
        Tuple tuple2 = (Tuple)object2;
        int n = 0;
        if (this.m_col == -1) {
            if (this.m_type == Integer.TYPE || this.m_type == Byte.TYPE) {
                n = ((LiteralComparator)this.m_cmp).compare(tuple.getInt(this.m_field), tuple2.getInt(this.m_field));
                return this.m_rev * n;
            } else if (this.m_type == Double.TYPE) {
                n = ((LiteralComparator)this.m_cmp).compare(tuple.getDouble(this.m_field), tuple2.getDouble(this.m_field));
                return this.m_rev * n;
            } else if (this.m_type == Long.TYPE) {
                n = ((LiteralComparator)this.m_cmp).compare(tuple.getLong(this.m_field), tuple2.getLong(this.m_field));
                return this.m_rev * n;
            } else if (this.m_type == Float.TYPE) {
                n = ((LiteralComparator)this.m_cmp).compare(tuple.getFloat(this.m_field), tuple2.getFloat(this.m_field));
                return this.m_rev * n;
            } else if (this.m_type == Boolean.TYPE) {
                n = ((LiteralComparator)this.m_cmp).compare(tuple.getBoolean(this.m_field), tuple2.getBoolean(this.m_field));
                return this.m_rev * n;
            } else {
                if (this.m_type.isPrimitive()) throw new IllegalStateException("Unsupported type: " + this.m_type.getName());
                n = this.m_cmp.compare(tuple.get(this.m_field), tuple2.get(this.m_field));
            }
            return this.m_rev * n;
        } else if (this.m_type == Integer.TYPE || this.m_type == Byte.TYPE) {
            n = ((LiteralComparator)this.m_cmp).compare(tuple.getInt(this.m_col), tuple2.getInt(this.m_col));
            return this.m_rev * n;
        } else if (this.m_type == Double.TYPE) {
            n = ((LiteralComparator)this.m_cmp).compare(tuple.getDouble(this.m_col), tuple2.getDouble(this.m_col));
            return this.m_rev * n;
        } else if (this.m_type == Long.TYPE) {
            n = ((LiteralComparator)this.m_cmp).compare(tuple.getLong(this.m_col), tuple2.getLong(this.m_col));
            return this.m_rev * n;
        } else if (this.m_type == Float.TYPE) {
            n = ((LiteralComparator)this.m_cmp).compare(tuple.getFloat(this.m_col), tuple2.getFloat(this.m_col));
            return this.m_rev * n;
        } else if (this.m_type == Boolean.TYPE) {
            n = ((LiteralComparator)this.m_cmp).compare(tuple.getBoolean(this.m_col), tuple2.getBoolean(this.m_col));
            return this.m_rev * n;
        } else {
            if (this.m_type.isPrimitive()) throw new IllegalStateException("Unsupported type: " + this.m_type.getName());
            n = this.m_cmp.compare(tuple.get(this.m_col), tuple2.get(this.m_col));
        }
        return this.m_rev * n;
    }
}

