/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.util.ui.UILib;

public class RotationControl
extends ControlAdapter {
    private Point down = new Point();
    private double baseAngle = 0.0;
    private int m_button;

    public RotationControl() {
        this(16);
    }

    public RotationControl(int n) {
        this.m_button = n;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.m_button)) {
            Display display = (Display)mouseEvent.getComponent();
            display.setCursor(Cursor.getPredefinedCursor(11));
            this.down.setLocation(mouseEvent.getPoint());
            this.baseAngle = Double.NaN;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.m_button)) {
            int n = mouseEvent.getY() - this.down.y;
            int n2 = mouseEvent.getX() - this.down.x;
            double d = Math.atan2(n, n2);
            if (!Double.isNaN(this.baseAngle)) {
                Display display = (Display)mouseEvent.getComponent();
                display.rotate(this.down, d - this.baseAngle);
            }
            this.baseAngle = d;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.m_button)) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

