/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Table;
import prefuse.data.query.NumberRangeModel;
import prefuse.util.ArrayLib;
import prefuse.util.MathLib;
import prefuse.util.PrefuseLib;
import prefuse.util.ui.ValuedRangeModel;
import prefuse.visual.VisualItem;

public class StackedAreaChart
extends Layout {
    private String m_field;
    private String m_start;
    private String m_end;
    private String[] columns;
    private double[] baseline;
    private double[] peaks;
    private float[] poly;
    private double m_padding = 0.05;
    private float m_threshold;
    private Rectangle2D bounds;
    private int m_orientation = 3;
    private boolean m_horiz = false;
    private boolean m_top = false;
    private boolean m_norm = false;
    private NumberRangeModel m_model;

    public StackedAreaChart(String string, String string2, String[] stringArray) {
        this(string, string2, stringArray, 1.0);
    }

    public StackedAreaChart(String string, String string2, String[] stringArray, double d) {
        super(string);
        this.columns = stringArray;
        this.baseline = new double[stringArray.length];
        this.peaks = new double[stringArray.length];
        this.poly = new float[4 * stringArray.length];
        this.m_field = string2;
        this.m_start = PrefuseLib.getStartField(string2);
        this.m_end = PrefuseLib.getEndField(string2);
        this.setThreshold(d);
        this.m_model = new NumberRangeModel(0, 1, 0, 1);
    }

    public void setColumns(String[] stringArray) {
        this.columns = stringArray;
    }

    public void setNormalized(boolean bl) {
        this.m_norm = bl;
    }

    public boolean isNormalized() {
        return this.m_norm;
    }

    public double getPaddingPercentage() {
        return this.m_padding;
    }

    public void setPaddingPercentage(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Illegal padding percentage: " + d);
        }
        this.m_padding = d;
    }

    public double getThreshold() {
        return this.m_threshold;
    }

    public void setThreshold(double d) {
        this.m_threshold = (float)d;
    }

    public ValuedRangeModel getRangeModel() {
        return this.m_model;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public void setOrientation(int n) {
        if (n != 2 && n != 3 && n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid orientation value: " + n);
        }
        this.m_orientation = n;
        this.m_horiz = this.m_orientation == 0 || this.m_orientation == 1;
        this.m_top = this.m_orientation == 2 || this.m_orientation == 0;
    }

    public void run(double d) {
        this.bounds = this.getLayoutBounds();
        Arrays.fill(this.baseline, 0.0);
        float f = (float)(this.m_horiz ? this.bounds.getMaxY() : this.bounds.getMinX());
        float f2 = (float)(this.m_horiz ? this.bounds.getWidth() : this.bounds.getHeight());
        int n = this.m_horiz ? 1 : 0;
        int n2 = this.m_horiz ? 0 : 1;
        int n3 = this.m_top ? 1 : -1;
        float f3 = (float)(this.m_horiz ? this.bounds.getMinY() - this.bounds.getMaxY() : this.bounds.getMaxX() - this.bounds.getMinX());
        f3 /= (float)(this.columns.length - 1);
        int n4 = this.columns.length;
        double d2 = this.getPeaks();
        float f4 = (float)(this.m_horiz ? (this.m_top ? this.bounds.getMinX() : this.bounds.getMaxX()) : (this.m_top ? this.bounds.getMinY() : this.bounds.getMaxY()));
        Arrays.fill(this.baseline, (double)f4);
        this.m_model.setValueRange(0.0, d2, 0.0, d2);
        Table table = (Table)this.m_vis.getGroup(this.m_group);
        Iterator iterator = table.tuplesReversed();
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            if (!visualItem.isVisible()) continue;
            float f5 = 0.0f;
            int n5 = n4;
            while (--n5 >= 0) {
                this.poly[2 * (n4 - 1 - n5) + n] = f + (float)n5 * f3;
                this.poly[2 * (n4 - 1 - n5) + n2] = (float)this.baseline[n5];
            }
            for (n5 = 0; n5 < this.columns.length; ++n5) {
                int n6 = 2 * (n4 + n5);
                double d3 = visualItem.getDouble(this.columns[n5]);
                int n7 = n5;
                this.baseline[n7] = this.baseline[n7] + (double)((float)n3 * f2) * MathLib.linearInterp(d3, 0.0, this.peaks[n5]);
                this.poly[n6 + n] = f + (float)n5 * f3;
                this.poly[n6 + n2] = (float)this.baseline[n5];
                f5 = Math.max(f5, Math.abs(this.poly[2 * (n4 - 1 - n5) + n2] - this.poly[n6 + n2]));
            }
            if (f5 < this.m_threshold) {
                visualItem.setVisible(false);
            }
            this.setX(visualItem, null, 0.0);
            this.setY(visualItem, null, 0.0);
            this.setPolygon(visualItem, this.poly);
        }
    }

    private double getPeaks() {
        double d = 0.0;
        Arrays.fill(this.peaks, 0.0);
        Iterator iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            int n = 0;
            while (n < this.columns.length) {
                double d2 = visualItem.getDouble(this.columns[n]);
                int n2 = n++;
                this.peaks[n2] = this.peaks[n2] + d2;
                d += d2;
            }
        }
        double d3 = ArrayLib.max(this.peaks);
        if (!this.m_norm) {
            Arrays.fill(this.peaks, d3);
        }
        if (!this.m_norm) {
            for (int i = 0; i < this.peaks.length; ++i) {
                int n = i;
                this.peaks[n] = this.peaks[n] + this.m_padding * this.peaks[i];
            }
            d3 += this.m_padding * d3;
        }
        if (this.m_norm) {
            d3 = 1.0;
        }
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        return d3;
    }

    private void setPolygon(VisualItem visualItem, float[] fArray) {
        float[] fArray2 = this.getPolygon(visualItem, this.m_field);
        float[] fArray3 = this.getPolygon(visualItem, this.m_start);
        float[] fArray4 = this.getPolygon(visualItem, this.m_end);
        System.arraycopy(fArray2, 0, fArray3, 0, fArray2.length);
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        System.arraycopy(fArray, 0, fArray4, 0, fArray.length);
        visualItem.setValidated(false);
    }

    private float[] getPolygon(VisualItem visualItem, String string) {
        float[] fArray = (float[])visualItem.get(string);
        if (fArray == null || fArray.length < 4 * this.columns.length) {
            int n = this.columns.length;
            float f = (float)(this.m_horiz ? this.bounds.getMinY() - this.bounds.getMaxY() : this.bounds.getMaxX() - this.bounds.getMinX());
            f /= (float)(n - 1);
            float f2 = (float)(this.m_horiz ? (this.m_top ? this.bounds.getMaxX() : this.bounds.getMinX()) : (this.m_top ? this.bounds.getMinY() : this.bounds.getMaxY()));
            float f3 = (float)(this.m_horiz ? this.bounds.getMaxY() : this.bounds.getMinX());
            int n2 = this.m_horiz ? 1 : 0;
            fArray = new float[4 * n];
            Arrays.fill(fArray, f2);
            for (int i = 0; i < n; ++i) {
                float f4;
                fArray[2 * (n + i) + n2] = f4 = (float)i * f + f3;
                fArray[2 * (n - 1 - i) + n2] = f4;
            }
            visualItem.set(string, (Object)fArray);
        }
        return fArray;
    }
}

