/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import prefuse.data.Table;
import prefuse.data.io.AbstractTableWriter;
import prefuse.data.io.DataIOException;
import prefuse.util.collections.IntIterator;

public class DelimitedTextTableWriter
extends AbstractTableWriter {
    private String m_delim;
    private boolean m_printHeader;

    public DelimitedTextTableWriter() {
        this("\t");
    }

    public DelimitedTextTableWriter(String string) {
        this(string, true);
    }

    public DelimitedTextTableWriter(String string, boolean bl) {
        this.m_delim = string;
        this.m_printHeader = bl;
    }

    public String getDelimiter() {
        return this.m_delim;
    }

    public void setDelimeter(String string) {
        this.m_delim = string;
    }

    public boolean isPrintHeader() {
        return this.m_printHeader;
    }

    public void setPrintHeader(boolean bl) {
        this.m_printHeader = bl;
    }

    public void writeTable(Table table, OutputStream outputStream) throws DataIOException {
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(outputStream));
            if (this.m_printHeader) {
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (i > 0) {
                        printStream.print(this.m_delim);
                    }
                    printStream.print(table.getColumnName(i));
                }
                printStream.println();
            }
            IntIterator intIterator = table.rows();
            while (intIterator.hasNext()) {
                int n = intIterator.nextInt();
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (i > 0) {
                        printStream.print(this.m_delim);
                    }
                    printStream.print(table.getString(n, table.getColumnName(i)));
                }
                printStream.println();
            }
            printStream.flush();
        }
        catch (Exception exception) {
            throw new DataIOException(exception);
        }
    }
}

