// .NAME vtkSlicerWelcomeGUI
// .SECTION Description
// Slicer Welcome and Overview


#ifndef __vtkSlicerWelcomeGUI_h
#define __vtkSlicerWelcomeGUI_h

#include "vtkSlicerWelcomeWin32Header.h"
#include "vtkSlicerModuleGUI.h"
#include "vtkSlicerWelcomeLogic.h"
#include "vtkSlicerWelcomeIcons.h"
#include "vtkSlicerModuleCollapsibleFrame.h"
#include "vtkIntArray.h"
#include "vtkKWCheckButton.h"
#include "vtkKWLabel.h"
#include "vtkKWCheckButtonWithLabel.h"

#include <string>

class vtkKWFrame;
class vtkSlicerWelcomeIcons;


class VTK_SLICERWELCOME_EXPORT vtkSlicerWelcomeGUI : public vtkSlicerModuleGUI
{
  public:
  static vtkSlicerWelcomeGUI *New();
  vtkTypeRevisionMacro(vtkSlicerWelcomeGUI,vtkSlicerModuleGUI);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Set the logic pointer from parent class pointer.
  // Overloads implementation in vtkSlicerModulesGUI
  // to allow loadable modules.
  virtual void SetModuleLogic ( vtkSlicerLogic *logic )
  {
  this->SetLogic(reinterpret_cast<vtkSlicerWelcomeLogic*> (logic)); 
  };

   // Description: Get/Set MRML node
  vtkGetObjectMacro (Logic, vtkSlicerWelcomeLogic);
  vtkSetObjectMacro (Logic, vtkSlicerWelcomeLogic);

  vtkGetObjectMacro ( SlicerWelcomeIcons, vtkSlicerWelcomeIcons );
  vtkSetObjectMacro ( SlicerWelcomeIcons, vtkSlicerWelcomeIcons );
  
  vtkGetMacro (GUIWidth, int );
  vtkSetMacro (GUIWidth, int );
  
  vtkGetObjectMacro (StartWithWelcome, vtkKWCheckButtonWithLabel);
  vtkSetObjectMacro (StartWithWelcome, vtkKWCheckButtonWithLabel);

  // Description:
  // Create widgets

  virtual void BuildGUI ( );
  virtual void TearDownGUI ( );
  vtkIntArray *NewObservableEvents();

  // Description:
  // Add obsereves to GUI widgets
  virtual void AddGUIObservers ( );

  // Description:
  // Remove obsereves to GUI widgets
  virtual void RemoveGUIObservers ( );
  
  // Description:
  // Pprocess events generated by GUI widgets
  virtual void ProcessGUIEvents ( vtkObject *caller, unsigned long event,
                                  void *callData );

  // Description:
  // Describe behavior at module startup and exit.
  virtual void Enter ( );
  virtual void Exit ( );
  virtual void Init ( );

  // Description:
  // Methods that construct individual panels.
  virtual void BuildWelcomeAndAboutPanel( vtkKWFrame *parent );
  virtual void BuildOverviewPanel( vtkKWFrame *parent );
  virtual void BuildLoadDataPanel( vtkKWFrame *parent );  
  virtual void BuildSaveDataPanel( vtkKWFrame *parent );
  virtual void BuildDataDisplayPanel( vtkKWFrame *parent );
  virtual void BuildModulesPanel ( vtkKWFrame *parent );
  virtual void BuildOtherHelpPanel( vtkKWFrame *parent );
  virtual void BuildConfigureModulesPanel( vtkKWFrame *parent );
  virtual void BuildCommunityPanel( vtkKWFrame *parent );
  virtual void BuildMouseModePanel( vtkKWFrame *parent );
  virtual void BuildViewAndLayoutPanel (vtkKWFrame *parent );

protected:
  vtkSlicerWelcomeGUI();
  ~vtkSlicerWelcomeGUI();
  vtkSlicerWelcomeGUI(const vtkSlicerWelcomeGUI&);
  void operator=(const vtkSlicerWelcomeGUI&);

  // Description:
  // updates status text in the slicer window.
  void SetStatusText( const char *txt);
  vtkSlicerWelcomeIcons *SlicerWelcomeIcons;
  vtkSlicerWelcomeLogic *Logic;
  int GUIWidth;

  vtkSlicerModuleCollapsibleFrame *WelcomeFrame;
  vtkSlicerModuleCollapsibleFrame *OverviewFrame;
  vtkSlicerModuleCollapsibleFrame *LoadFrame;
  vtkSlicerModuleCollapsibleFrame *SaveFrame;
  vtkSlicerModuleCollapsibleFrame *DisplayFrame;  
  vtkSlicerModuleCollapsibleFrame *ModulesFrame;
  vtkSlicerModuleCollapsibleFrame *ConfigureFrame;
  vtkSlicerModuleCollapsibleFrame *HintsFrame;
  vtkSlicerModuleCollapsibleFrame *CommunityFrame;
  vtkSlicerModuleCollapsibleFrame *CreditFrame;  
  vtkSlicerModuleCollapsibleFrame *MouseModeFrame;
  vtkSlicerModuleCollapsibleFrame *ViewAndLayoutFrame;

  vtkKWCheckButtonWithLabel *StartWithWelcome;
  bool Observed;
};

#endif

