/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.render.EdgeRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.render.ShapeRenderer;
import prefuse.util.PredicateChain;
import prefuse.visual.EdgeItem;
import prefuse.visual.VisualItem;

public class DefaultRendererFactory
implements RendererFactory {
    private PredicateChain m_chain = new PredicateChain();
    private Renderer m_itemRenderer;
    private Renderer m_edgeRenderer;

    public DefaultRendererFactory() {
        this(new ShapeRenderer());
    }

    public DefaultRendererFactory(Renderer renderer) {
        this(renderer, new EdgeRenderer());
    }

    public DefaultRendererFactory(Renderer renderer, Renderer renderer2) {
        this.m_itemRenderer = renderer;
        this.m_edgeRenderer = renderer2;
    }

    public void setDefaultRenderer(Renderer renderer) {
        this.m_itemRenderer = renderer;
    }

    public Renderer getDefaultRenderer() {
        return this.m_itemRenderer;
    }

    public void setDefaultEdgeRenderer(Renderer renderer) {
        this.m_edgeRenderer = renderer;
    }

    public Renderer getDefaultEdgeRenderer() {
        return this.m_edgeRenderer;
    }

    public void add(Predicate predicate, Renderer renderer) {
        this.m_chain.add(predicate, renderer);
    }

    public void add(String string, Renderer renderer) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        this.add(predicate, renderer);
    }

    public Renderer getRenderer(VisualItem visualItem) {
        Renderer renderer = (Renderer)this.m_chain.get(visualItem);
        if (renderer != null) {
            return renderer;
        }
        if (visualItem instanceof EdgeItem) {
            return this.m_edgeRenderer;
        }
        return this.m_itemRenderer;
    }
}

