#include "vtkObjectFactory.h"
#include "vtkMRMLAnnotationHierarchyNode.h"
#include "vtkMRMLAnnotationNode.h"

//------------------------------------------------------------------------------
vtkMRMLAnnotationHierarchyNode* vtkMRMLAnnotationHierarchyNode::New()
{
  // First try to create the object from the vtkObjectFactory
  vtkObject* ret = vtkObjectFactory::CreateInstance("vtkMRMLAnnotationHierarchyNode");
  if(ret)
    {
    return (vtkMRMLAnnotationHierarchyNode*)ret;
    }
  // If the factory was unable to create the object, then create it here.
  return new vtkMRMLAnnotationHierarchyNode;
}

//----------------------------------------------------------------------------
vtkMRMLAnnotationHierarchyNode::vtkMRMLAnnotationHierarchyNode()
{

}

//----------------------------------------------------------------------------
vtkMRMLAnnotationHierarchyNode::~vtkMRMLAnnotationHierarchyNode()
{

}

//----------------------------------------------------------------------------
void vtkMRMLAnnotationHierarchyNode::PrintSelf(ostream& os, vtkIndent indent)
{

  Superclass::PrintSelf(os,indent);

}

//----------------------------------------------------------------------------
void vtkMRMLAnnotationHierarchyNode::ReadXMLAttributes( const char** atts)
{
  Superclass::ReadXMLAttributes(atts);
}

//----------------------------------------------------------------------------
void vtkMRMLAnnotationHierarchyNode::WriteXML(ostream& of, int indent)
{
  Superclass::WriteXML(of,indent);
}

//---------------------------------------------------------------------------
void vtkMRMLAnnotationHierarchyNode::GetDirectChildren(vtkCollection *children)
{
  if (children == NULL)
    {
    return;
    }
  vtkMRMLScene *scene = this->GetScene();
  if (scene == NULL)
    {
    vtkErrorMacro("GetChildrenDisplayableNodes: scene is null, cannot find children of this node");
    return;
    }

  vtkMRMLAnnotationHierarchyNode *hnode = NULL;
  int numNodes = scene->GetNumberOfNodesByClass("vtkMRMLAnnotationHierarchyNode");
  for (int n=0; n < numNodes; n++)
    {
    hnode = vtkMRMLAnnotationHierarchyNode::SafeDownCast(scene->GetNthNodeByClass(n, "vtkMRMLAnnotationHierarchyNode"));
    vtkDebugMacro("GetChildrenHierarchyNodes: hierarchy node " << n << " has id " << hnode->GetID());

    // let's check if the found hnode is a direct child of this node
    if (hnode->GetID() && this->GetID() && hnode->GetParentNodeID() &&
        strcmp(hnode->GetID(), this->GetID()) &&
        !strcmp(hnode->GetParentNodeID(),this->GetID()))
      {
      // it is a direct child

      // now let's check if it is a user-created hierarchy
      if (!hnode->GetHideFromEditors())
        {
        // yes it is
        children->AddItem(hnode);
        }
      else
        {
        // it must be a 1-1 hierarchy node coming directly with an annotation
        vtkMRMLAnnotationNode* anode = vtkMRMLAnnotationNode::SafeDownCast(scene->GetNodeByID(hnode->GetDisplayableNodeID()));
        if (anode)
          {
          children->AddItem(anode);
          }
        } // if user-created check

      } // check if it is a direct child of this

    } // loop through all nodes
}
