/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import prefuse.util.collections.AbstractTreeMap;
import prefuse.util.collections.IntIntSortedMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.LiteralComparator;
import prefuse.util.collections.LiteralIterator;

public class IntIntTreeMap
extends AbstractTreeMap
implements IntIntSortedMap {
    private IntEntry dummy = new IntEntry(Integer.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public IntIntTreeMap() {
        this(null, false);
    }

    public IntIntTreeMap(boolean bl) {
        this(null, bl);
    }

    public IntIntTreeMap(LiteralComparator literalComparator) {
        this(literalComparator, false);
    }

    public IntIntTreeMap(LiteralComparator literalComparator, boolean bl) {
        super(literalComparator, bl);
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    public boolean containsKey(int n) {
        return this.find(n, 0) != NIL;
    }

    public int get(int n) {
        AbstractTreeMap.Entry entry = this.find(n, 0);
        return entry == NIL ? Integer.MIN_VALUE : entry.val;
    }

    public int put(int n, int n2) {
        AbstractTreeMap.Entry entry = this.root;
        this.lastOrder = 0;
        if (entry == NIL) {
            this.incrementSize(true);
            this.root = new IntEntry(n, n2, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = n;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int n3;
            if ((n3 = this.compare(this.dummy, entry)) == 0) {
                return entry.setValue(n2);
            }
            if (n3 < 0) {
                if (entry.left != NIL) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                entry.left = new IntEntry(n, n2, entry, this.lastOrder);
                this.fixUpInsert(entry.left);
                return Integer.MIN_VALUE;
            }
            if (entry.right == NIL) break;
            entry = entry.right;
        }
        this.incrementSize(this.lastOrder == 0);
        entry.right = new IntEntry(n, n2, entry, this.lastOrder);
        this.fixUpInsert(entry.right);
        return Integer.MIN_VALUE;
    }

    public int remove(int n) {
        AbstractTreeMap.Entry entry = this.allowDuplicates ? this.findPredecessor(n, Integer.MAX_VALUE) : this.find(n, 0);
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        int n2 = entry.val;
        this.remove(entry);
        return n2;
    }

    public int remove(int n, int n2) {
        AbstractTreeMap.Entry entry = this.findCeiling(n, 0);
        if (entry != NIL && entry.getIntKey() != n) {
            entry = this.successor(entry);
        }
        if (entry == NIL || entry.getIntKey() != n) {
            return Integer.MIN_VALUE;
        }
        while (entry.val != n2 && entry != NIL) {
            entry = this.successor(entry);
        }
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        this.remove(entry);
        return n2;
    }

    public int getLast(int n) {
        AbstractTreeMap.Entry entry = this.findPredecessor(n, Integer.MAX_VALUE);
        return entry == NIL || ((IntEntry)entry).key != n ? Integer.MIN_VALUE : entry.val;
    }

    public int getPreviousValue(int n, int n2) {
        AbstractTreeMap.Entry entry = this.find(n, n2);
        return this.predecessor((AbstractTreeMap.Entry)entry).val;
    }

    public int getNextValue(int n, int n2) {
        AbstractTreeMap.Entry entry = this.find(n, n2);
        return this.successor((AbstractTreeMap.Entry)entry).val;
    }

    public int firstKey() {
        return this.minimum(this.root).getIntKey();
    }

    public int lastKey() {
        return this.maximum(this.root).getIntKey();
    }

    public LiteralIterator keyIterator() {
        return new KeyIterator();
    }

    public LiteralIterator keyRangeIterator(int n, boolean bl, int n2, boolean bl2) {
        AbstractTreeMap.Entry entry;
        AbstractTreeMap.Entry entry2;
        if (this.cmp.compare(n, n2) <= 0) {
            entry2 = this.findCeiling(n, bl ? 0 : Integer.MAX_VALUE);
            entry = this.findCeiling(n2, bl2 ? Integer.MAX_VALUE : 0);
        } else {
            entry2 = this.findCeiling(n, bl ? Integer.MAX_VALUE : 0);
            entry2 = this.predecessor(entry2);
            entry = this.findCeiling(n2, bl2 ? 0 : Integer.MAX_VALUE);
            entry = this.predecessor(entry);
        }
        return new KeyIterator(entry2, entry);
    }

    public IntIterator valueRangeIterator(int n, boolean bl, int n2, boolean bl2) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(n, bl, n2, bl2));
    }

    protected int compare(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
        int n = this.cmp.compare(entry.getIntKey(), entry2.getIntKey());
        if (this.allowDuplicates && n == 0) {
            n = entry.order < entry2.order ? -1 : (entry.order > entry2.order ? 1 : 0);
            this.lastOrder = 1 + (n < 0 ? entry.order : entry2.order);
        }
        return n;
    }

    private AbstractTreeMap.Entry find(int n, int n2) {
        this.dummy.key = n;
        this.dummy.order = n2;
        AbstractTreeMap.Entry entry = this.find(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findPredecessor(int n, int n2) {
        this.dummy.key = n;
        this.dummy.order = n2;
        AbstractTreeMap.Entry entry = this.findPredecessor(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findCeiling(int n, int n2) {
        this.dummy.key = n;
        this.dummy.order = n2;
        AbstractTreeMap.Entry entry = this.findCeiling(this.dummy);
        return entry;
    }

    private class KeyIterator
    extends AbstractTreeMap.KeyIterator {
        public KeyIterator() {
        }

        public KeyIterator(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
            super(entry, entry2);
        }

        public boolean isIntSupported() {
            return true;
        }

        public int nextInt() {
            return this.nextEntry().getIntKey();
        }
    }

    static class IntEntry
    extends AbstractTreeMap.Entry {
        int key;

        public IntEntry(int n, int n2) {
            super(n2);
            this.key = n;
        }

        public IntEntry(int n, int n2, AbstractTreeMap.Entry entry, int n3) {
            super(n2, entry, n3);
            this.key = n;
        }

        public int getIntKey() {
            return this.key;
        }

        public Object getKey() {
            return new Integer(this.key);
        }

        public boolean keyEquals(AbstractTreeMap.Entry entry) {
            return entry instanceof IntEntry && this.key == ((IntEntry)entry).key;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IntEntry)) {
                return false;
            }
            IntEntry intEntry = (IntEntry)object;
            return this.key == intEntry.key && this.val == intEntry.val;
        }

        public int hashCode() {
            int n = this.key;
            int n2 = this.val;
            return n ^ n2 ^ this.order;
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        public void copyFields(AbstractTreeMap.Entry entry) {
            super.copyFields(entry);
            this.key = entry.getIntKey();
        }
    }
}

