/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.Display;
import prefuse.action.GroupAction;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;

public abstract class Layout
extends GroupAction {
    protected Rectangle2D m_bounds = null;
    protected Point2D m_anchor = null;
    protected boolean m_margin = false;
    protected Insets m_insets = new Insets(0, 0, 0, 0);
    protected double[] m_bpts = new double[4];
    protected Rectangle2D m_tmpb = new Rectangle2D.Double();
    protected Point2D m_tmpa = new Point2D.Double();

    public Layout() {
    }

    public Layout(String string) {
        super(string);
    }

    public Layout(String string, long l) {
        super(string, l);
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.m_insets.top = n;
        this.m_insets.left = n2;
        this.m_insets.bottom = n3;
        this.m_insets.right = n4;
        this.m_margin = true;
    }

    public Rectangle2D getLayoutBounds() {
        if (this.m_bounds != null) {
            return this.m_bounds;
        }
        if (this.m_vis != null && this.m_vis.getDisplayCount() > 0) {
            Display display = this.m_vis.getDisplay(0);
            Insets insets = this.m_margin ? this.m_insets : display.getInsets(this.m_insets);
            this.m_bpts[0] = insets.left;
            this.m_bpts[1] = insets.top;
            this.m_bpts[2] = display.getWidth() - insets.right;
            this.m_bpts[3] = display.getHeight() - insets.bottom;
            display.getInverseTransform().transform(this.m_bpts, 0, this.m_bpts, 0, 2);
            this.m_tmpb.setRect(this.m_bpts[0], this.m_bpts[1], this.m_bpts[2] - this.m_bpts[0], this.m_bpts[3] - this.m_bpts[1]);
            return this.m_tmpb;
        }
        return null;
    }

    public void setLayoutBounds(Rectangle2D rectangle2D) {
        this.m_bounds = rectangle2D;
    }

    public Point2D getLayoutAnchor() {
        if (this.m_anchor != null) {
            return this.m_anchor;
        }
        this.m_tmpa.setLocation(0.0, 0.0);
        if (this.m_vis != null) {
            Display display = this.m_vis.getDisplay(0);
            this.m_tmpa.setLocation((double)display.getWidth() / 2.0, (double)display.getHeight() / 2.0);
            display.getInverseTransform().transform(this.m_tmpa, this.m_tmpa);
        }
        return this.m_tmpa;
    }

    public void setLayoutAnchor(Point2D point2D) {
        this.m_anchor = point2D;
    }

    public void setX(VisualItem visualItem, VisualItem visualItem2, double d) {
        PrefuseLib.setX(visualItem, visualItem2, d);
    }

    public void setY(VisualItem visualItem, VisualItem visualItem2, double d) {
        PrefuseLib.setY(visualItem, visualItem2, d);
    }
}

