/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import prefuse.util.collections.AbstractTreeMap;
import prefuse.util.collections.DoubleIntSortedMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.LiteralComparator;
import prefuse.util.collections.LiteralIterator;

public class DoubleIntTreeMap
extends AbstractTreeMap
implements DoubleIntSortedMap {
    private DoubleEntry dummy = new DoubleEntry(Double.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public DoubleIntTreeMap() {
        this(null, false);
    }

    public DoubleIntTreeMap(boolean bl) {
        this(null, bl);
    }

    public DoubleIntTreeMap(LiteralComparator literalComparator) {
        this(literalComparator, false);
    }

    public DoubleIntTreeMap(LiteralComparator literalComparator, boolean bl) {
        super(literalComparator, bl);
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    public boolean containsKey(double d) {
        return this.find(d, 0) != NIL;
    }

    public int get(double d) {
        AbstractTreeMap.Entry entry = this.find(d, 0);
        return entry == NIL ? Integer.MIN_VALUE : entry.val;
    }

    public int put(double d, int n) {
        AbstractTreeMap.Entry entry = this.root;
        this.lastOrder = 0;
        if (entry == NIL) {
            this.incrementSize(true);
            this.root = new DoubleEntry(d, n, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = d;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int n2;
            if ((n2 = this.compare(this.dummy, entry)) == 0) {
                return entry.setValue(n);
            }
            if (n2 < 0) {
                if (entry.left != NIL) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                entry.left = new DoubleEntry(d, n, entry, this.lastOrder);
                this.fixUpInsert(entry.left);
                return Integer.MIN_VALUE;
            }
            if (entry.right == NIL) break;
            entry = entry.right;
        }
        this.incrementSize(this.lastOrder == 0);
        entry.right = new DoubleEntry(d, n, entry, this.lastOrder);
        this.fixUpInsert(entry.right);
        return Integer.MIN_VALUE;
    }

    public int remove(double d) {
        AbstractTreeMap.Entry entry = this.allowDuplicates ? this.findPredecessor(d, Integer.MAX_VALUE) : this.find(d, 0);
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        int n = entry.val;
        this.remove(entry);
        return n;
    }

    public int remove(double d, int n) {
        AbstractTreeMap.Entry entry = this.findCeiling(d, 0);
        if (entry != NIL && entry.getDoubleKey() != d) {
            entry = this.successor(entry);
        }
        if (entry == NIL || entry.getDoubleKey() != d) {
            return Integer.MIN_VALUE;
        }
        while (entry.val != n && entry != NIL) {
            entry = this.successor(entry);
        }
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        this.remove(entry);
        return n;
    }

    public double firstKey() {
        return this.minimum(this.root).getDoubleKey();
    }

    public double lastKey() {
        return this.maximum(this.root).getDoubleKey();
    }

    public LiteralIterator keyIterator() {
        return new KeyIterator();
    }

    public LiteralIterator keyRangeIterator(double d, boolean bl, double d2, boolean bl2) {
        AbstractTreeMap.Entry entry;
        AbstractTreeMap.Entry entry2;
        if (this.cmp.compare(d, d2) <= 0) {
            entry2 = this.findCeiling(d, bl ? 0 : Integer.MAX_VALUE);
            entry = this.findCeiling(d2, bl2 ? Integer.MAX_VALUE : 0);
        } else {
            entry2 = this.findCeiling(d, bl ? Integer.MAX_VALUE : 0);
            entry2 = this.predecessor(entry2);
            entry = this.findCeiling(d2, bl2 ? 0 : Integer.MAX_VALUE);
            entry = this.predecessor(entry);
        }
        return new KeyIterator(entry2, entry);
    }

    public IntIterator valueRangeIterator(double d, boolean bl, double d2, boolean bl2) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(d, bl, d2, bl2));
    }

    protected int compare(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
        int n = this.cmp.compare(entry.getDoubleKey(), entry2.getDoubleKey());
        if (this.allowDuplicates && n == 0) {
            n = entry.order < entry2.order ? -1 : (entry.order > entry2.order ? 1 : 0);
            this.lastOrder = 1 + (n < 0 ? entry.order : entry2.order);
        }
        return n;
    }

    private AbstractTreeMap.Entry find(double d, int n) {
        this.dummy.key = d;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.find(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findPredecessor(double d, int n) {
        this.dummy.key = d;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.findPredecessor(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findCeiling(double d, int n) {
        this.dummy.key = d;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.findCeiling(this.dummy);
        return entry;
    }

    private class KeyIterator
    extends AbstractTreeMap.KeyIterator {
        public KeyIterator() {
        }

        public KeyIterator(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
            super(entry, entry2);
        }

        public boolean isDoubleSupported() {
            return true;
        }

        public double nextDouble() {
            return this.nextEntry().getDoubleKey();
        }
    }

    static class DoubleEntry
    extends AbstractTreeMap.Entry {
        double key;

        public DoubleEntry(double d, int n) {
            super(n);
            this.key = d;
        }

        public DoubleEntry(double d, int n, AbstractTreeMap.Entry entry, int n2) {
            super(n, entry, n2);
            this.key = d;
        }

        public double getDoubleKey() {
            return this.key;
        }

        public Object getKey() {
            return new Double(this.key);
        }

        public boolean keyEquals(AbstractTreeMap.Entry entry) {
            return entry instanceof DoubleEntry && this.key == ((DoubleEntry)entry).key;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DoubleEntry)) {
                return false;
            }
            DoubleEntry doubleEntry = (DoubleEntry)object;
            return this.key == doubleEntry.key && this.val == doubleEntry.val;
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.key);
            int n = (int)(l ^ l >>> 32);
            int n2 = this.val;
            return n ^ n2 ^ this.order;
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        public void copyFields(AbstractTreeMap.Entry entry) {
            super.copyFields(entry);
            this.key = entry.getDoubleKey();
        }
    }
}

